/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.JwkResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.util.StringHelper;

public class OpenIDRequestObjectHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethod1(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethod1");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("address"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethod2(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethod2");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNotNull((Object)response2.getClaim("address"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethod3(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethod3");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid");
        String state = "STATE0";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The code is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethod4(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethod4");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS384, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("sub", ClaimValue.createSingleValue((String)userId)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethod5(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethod5");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS512, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("sub", ClaimValue.createSingleValue((String)userId)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethod6(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethod6");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createEssential((boolean)true)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodRS256(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodRS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.RS256, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodRS384(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodRS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.RS384, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodRS512(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodRS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.RS512, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodES256(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodES256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
        Assert.assertNotNull((Object)response3.getClaim("address"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodES384(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodES384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        String clientSecret = response.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
        Assert.assertNotNull((Object)response3.getClaim("address"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodES512(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodES512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodRS256X509Cert(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodRS256X509Cert");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.RS256, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodRS384X509Cert(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodRS384X509Cert");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.RS384, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodRS512X509Cert(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodRS512X509Cert");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.RS512, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodES256X509Cert(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodES256X509Cert");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
        Assert.assertNotNull((Object)response3.getClaim("address"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodES384X509Cert(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodES384X509Cert");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
        Assert.assertNotNull((Object)response3.getClaim("address"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodES512X509Cert(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestParameterMethodES512X509Cert");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.setKeyId(keyId);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
        jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        request.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
        OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodFail1(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodFail1");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.setRequest("INVALID_OPENID_REQUEST_OBJECT");
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse response = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
            Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
            Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
            Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodFail2(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodFail2");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            String clientSecret = registerResponse.getClientSecret();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt + "INVALID_KEY");
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse response = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
            Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
            Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
            Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodFail3(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodFail3");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            String clientSecret = registerResponse.getClientSecret();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            jwtAuthorizationRequest.setClientId("INVALID_CLIENT_ID");
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
            Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
            Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
            Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodFail4(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodFail4");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            String clientSecret = registerResponse.getClientSecret();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("sub", ClaimValue.createSingleValue((String)"INVALID_USER_ID")));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
            Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
            Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
            Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "requestFileBasePath", "requestFileBaseUrl", "sectorIdentifierUri"})
    @Test
    public void requestFileMethod(String userId, String userSecret, String redirectUris, String redirectUri, @Optional String requestFileBasePath, String requestFileBaseUrl, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestFileMethod");
        if (StringHelper.isEmpty((String)requestFileBasePath)) {
            return;
        }
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        try {
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            String hash = Base64Util.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)authJwt));
            String fileName = UUID.randomUUID().toString() + ".txt";
            String filePath = requestFileBasePath + File.separator + fileName;
            String fileUrl = requestFileBaseUrl + "/" + fileName;
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(authJwt);
            bw.close();
            fw.close();
            authorizationRequest.setRequestUri(fileUrl);
            System.out.println("Request JWT: " + authJwt);
            System.out.println("Request File Path: " + filePath);
            System.out.println("Request File URL: " + fileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void requestFileMethodFail1(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) {
        try {
            this.showTitle("requestFileMethodFail1");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            authorizationRequest.setRequest("FAKE_REQUEST");
            authorizationRequest.setRequestUri("FAKE_REQUEST_URI");
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse response = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
            Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
            Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
            Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "requestFileBaseUrl", "sectorIdentifierUri"})
    @Test
    public void requestFileMethodFail2(String userId, String userSecret, String redirectUris, String redirectUri, String requestFileBaseUrl, String sectorIdentifierUri) {
        try {
            this.showTitle("requestFileMethodFail2");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            authorizationRequest.setRequestUri(requestFileBaseUrl + "/FAKE_REQUEST_URI");
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse response = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
            Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "requestFileBasePath", "requestFileBaseUrl", "sectorIdentifierUri"})
    @Test
    public void requestFileMethodFail3(String userId, String userSecret, String redirectUris, String redirectUri, @Optional String requestFileBasePath, String requestFileBaseUrl, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestFileMethodFail3");
        if (StringHelper.isEmpty((String)requestFileBasePath)) {
            return;
        }
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        try {
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            String hash = "INVALID_HASH";
            String fileName = UUID.randomUUID().toString() + ".txt";
            String filePath = requestFileBasePath + File.separator + fileName;
            String fileUrl = requestFileBaseUrl + "/" + fileName + "#" + hash;
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(authJwt);
            bw.close();
            fw.close();
            authorizationRequest.setRequestUri(fileUrl);
            System.out.println("Request JWT: " + authJwt);
            System.out.println("Request File Path: " + filePath);
            System.out.println("Request File URL: " + fileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse response = authorizeClient.exec();
        OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
        Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodAlgNone(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodAlgNone");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.NONE);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, SignatureAlgorithm.NONE, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response1 = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
            Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
            String accessToken = response1.getAccessToken();
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
            OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
            Assert.assertNotNull((Object)response3.getClaim("sub"));
            Assert.assertNotNull((Object)response3.getClaim("name"));
            Assert.assertNotNull((Object)response3.getClaim("given_name"));
            Assert.assertNotNull((Object)response3.getClaim("family_name"));
            Assert.assertNotNull((Object)response3.getClaim("email"));
            Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)response3.getClaim("locale"));
            Assert.assertNotNull((Object)response3.getClaim("address"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodAlgRSAOAEPEncA256GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodAlgRSAOAEPEncA256GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            JwkClient jwkClient = new JwkClient(this.jwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String keyId = jwkResponse.getKeyId(SignatureAlgorithm.RS256);
            Assert.assertNotNull((Object)keyId);
            JSONObject jwks = JwtUtil.getJSONWebKeys((String)this.jwksUri);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, KeyEncryptionAlgorithm.RSA_OAEP, BlockEncryptionAlgorithm.A256GCM, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt(jwks);
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response1 = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
            Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
            String accessToken = response1.getAccessToken();
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
            OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
            Assert.assertNotNull((Object)response3.getClaim("sub"));
            Assert.assertNotNull((Object)response3.getClaim("name"));
            Assert.assertNotNull((Object)response3.getClaim("given_name"));
            Assert.assertNotNull((Object)response3.getClaim("family_name"));
            Assert.assertNotNull((Object)response3.getClaim("email"));
            Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)response3.getClaim("locale"));
            Assert.assertNotNull((Object)response3.getClaim("address"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodAlgRSA15EncA128CBCPLUSHS256(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodAlgRSA15EncA128CBCPLUSHS256");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            JwkClient jwkClient = new JwkClient(this.jwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String keyId = jwkResponse.getKeyId(SignatureAlgorithm.RS256);
            Assert.assertNotNull((Object)keyId);
            JSONObject jwks = JwtUtil.getJSONWebKeys((String)this.jwksUri);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A128CBC_PLUS_HS256, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt(jwks);
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response1 = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
            Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
            String accessToken = response1.getAccessToken();
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
            OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
            Assert.assertNotNull((Object)response3.getClaim("sub"));
            Assert.assertNotNull((Object)response3.getClaim("name"));
            Assert.assertNotNull((Object)response3.getClaim("given_name"));
            Assert.assertNotNull((Object)response3.getClaim("family_name"));
            Assert.assertNotNull((Object)response3.getClaim("email"));
            Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)response3.getClaim("locale"));
            Assert.assertNotNull((Object)response3.getClaim("address"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodAlgRSA15EncA256CBCPLUSHS512(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodAlgRSA15EncA256CBCPLUSHS512");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            JwkClient jwkClient = new JwkClient(this.jwksUri);
            JwkResponse jwkResponse = jwkClient.exec();
            String keyId = jwkResponse.getKeyId(SignatureAlgorithm.RS256);
            Assert.assertNotNull((Object)keyId);
            JSONObject jwks = JwtUtil.getJSONWebKeys((String)this.jwksUri);
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A256CBC_PLUS_HS512, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt(jwks);
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response1 = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
            Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
            String accessToken = response1.getAccessToken();
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
            OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
            Assert.assertNotNull((Object)response3.getClaim("sub"));
            Assert.assertNotNull((Object)response3.getClaim("name"));
            Assert.assertNotNull((Object)response3.getClaim("given_name"));
            Assert.assertNotNull((Object)response3.getClaim("family_name"));
            Assert.assertNotNull((Object)response3.getClaim("email"));
            Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)response3.getClaim("locale"));
            Assert.assertNotNull((Object)response3.getClaim("address"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodAlgA128KWEncA128GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodAlgA128KWEncA128GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, KeyEncryptionAlgorithm.A128KW, BlockEncryptionAlgorithm.A128GCM, clientSecret);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response1 = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
            Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
            String accessToken = response1.getAccessToken();
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
            OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
            Assert.assertNotNull((Object)response3.getClaim("sub"));
            Assert.assertNotNull((Object)response3.getClaim("name"));
            Assert.assertNotNull((Object)response3.getClaim("given_name"));
            Assert.assertNotNull((Object)response3.getClaim("family_name"));
            Assert.assertNotNull((Object)response3.getClaim("email"));
            Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)response3.getClaim("locale"));
            Assert.assertNotNull((Object)response3.getClaim("address"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestParameterMethodAlgA256KWEncA256GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("requestParameterMethodAlgA256KWEncA256GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse response = registerClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
            Assert.assertNotNull((Object)response.getClientId());
            Assert.assertNotNull((Object)response.getClientSecret());
            Assert.assertNotNull((Object)response.getRegistrationAccessToken());
            Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
            String clientId = response.getClientId();
            String clientSecret = response.getClientSecret();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            request.setState(state);
            request.setAuthUsername(userId);
            request.setAuthPassword(userSecret);
            request.getPrompts().add(Prompt.NONE);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(request, KeyEncryptionAlgorithm.A256KW, BlockEncryptionAlgorithm.A256GCM, clientSecret);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            request.setRequest(authJwt);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)request);
            AuthorizationResponse response1 = authorizeClient.exec();
            OpenIDRequestObjectHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
            Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)response1.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)response1.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
            String accessToken = response1.getAccessToken();
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse response3 = userInfoClient.execUserInfo(accessToken);
            OpenIDRequestObjectHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
            Assert.assertNotNull((Object)response3.getClaim("sub"));
            Assert.assertNotNull((Object)response3.getClaim("name"));
            Assert.assertNotNull((Object)response3.getClaim("given_name"));
            Assert.assertNotNull((Object)response3.getClaim("family_name"));
            Assert.assertNotNull((Object)response3.getClaim("email"));
            Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)response3.getClaim("locale"));
            Assert.assertNotNull((Object)response3.getClaim("address"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }
}

