/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class MultiStepAuthorizationCodeFlowHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationMultiStepCodeFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationMultiStepCodeFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "phone", "user_name");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, scopes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String nonce = UUID.randomUUID().toString();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, scopes, clientId, nonce, 2);
        String authorizationCode = authorizationResponse.getCode();
        Assert.assertNotNull((Object)authorizationCode, (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The authorization scope is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The authorization id_token is null");
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        MultiStepAuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
    }

    private AuthorizationResponse requestAuthorization(String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes, List<String> scopes, String clientId, String nonce, int countAuthzSteps) {
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret, true, false, countAuthzSteps);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        return authorizationResponse;
    }

    private RegisterResponse registerClient(String redirectUris, List<ResponseType> responseTypes, List<String> scopes, String sectorIdentifierUri) {
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setScope(scopes);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        MultiStepAuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        return registerResponse;
    }
}

