/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.JwkResponse;
import org.xdi.oxauth.model.jwk.JSONWebKey;

public class JwkRestWebServiceHttpTest
extends BaseTest {
    @Test
    public void requestJwks() throws Exception {
        this.showTitle("requestJwks");
        JwkClient jwkClient = new JwkClient(this.jwksUri);
        JwkResponse response = jwkClient.exec();
        JwkRestWebServiceHttpTest.showClient((BaseClient)jwkClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"Unexpected result: entity is null");
        Assert.assertNotNull((Object)response.getJwks(), (String)"Unexpected result: jwks is null");
        Assert.assertNotNull((Object)response.getJwks().getKeys(), (String)"Unexpected result: keys is null");
        Assert.assertTrue((response.getJwks().getKeys().size() > 0 ? 1 : 0) != 0, (String)"Unexpected result: keys is empty");
        for (JSONWebKey JSONWebKey2 : response.getJwks().getKeys()) {
            Assert.assertNotNull((Object)JSONWebKey2.getKid(), (String)"Unexpected result: kid is null");
            Assert.assertNotNull((Object)JSONWebKey2.getUse(), (String)"Unexpected result: use is null");
        }
    }

    @Parameters(value={"clientJwksUri"})
    @Test
    public void requestClientJwks(String clientJwksUri) throws Exception {
        this.showTitle("requestJwks");
        JwkClient jwkClient = new JwkClient(clientJwksUri);
        JwkResponse response = jwkClient.exec();
        JwkRestWebServiceHttpTest.showClient((BaseClient)jwkClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"Unexpected result: entity is null");
        Assert.assertNotNull((Object)response.getJwks(), (String)"Unexpected result: jwks is null");
        Assert.assertNotNull((Object)response.getJwks().getKeys(), (String)"Unexpected result: keys is null");
        Assert.assertTrue((response.getJwks().getKeys().size() > 0 ? 1 : 0) != 0, (String)"Unexpected result: keys is empty");
        for (JSONWebKey JSONWebKey2 : response.getJwks().getKeys()) {
            Assert.assertNotNull((Object)JSONWebKey2.getKid(), (String)"Unexpected result: kid is null");
            Assert.assertNotNull((Object)JSONWebKey2.getUse(), (String)"Unexpected result: use is null");
        }
    }
}

