/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.EndSessionClient;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class GrantTypesRestrictionHttpTest
extends BaseTest {
    @Test(dataProvider="grantTypesRestrictionDataProvider")
    public void grantTypesRestriction(List<ResponseType> responseTypes, List<ResponseType> expectedResponseTypes, List<GrantType> grantTypes, List<GrantType> expectedGrantTypes, String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String postLogoutRedirectUri, String logoutUri) throws Exception {
        this.showTitle("grantTypesRestriction");
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "user_name");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setScope(scopes);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setFrontChannelLogoutUris((List)Lists.newArrayList((Object[])new String[]{logoutUri}));
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        GrantTypesRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200);
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        Assert.assertNotNull((Object)registerResponse.getResponseTypes());
        Assert.assertTrue((boolean)registerResponse.getResponseTypes().containsAll(expectedResponseTypes));
        Assert.assertNotNull((Object)registerResponse.getGrantTypes());
        Assert.assertTrue((boolean)registerResponse.getGrantTypes().containsAll(expectedGrantTypes));
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readRequest);
        RegisterResponse readResponse = registerClient.exec();
        GrantTypesRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)readResponse.getStatus(), (int)200);
        Assert.assertNotNull((Object)readResponse.getClientId());
        Assert.assertNotNull((Object)readResponse.getClientSecret());
        Assert.assertNotNull((Object)readResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)readResponse.getRegistrationClientUri());
        Assert.assertNotNull((Object)readResponse.getClientSecretExpiresAt());
        Assert.assertNotNull(readResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        Assert.assertNotNull((Object)readResponse.getResponseTypes());
        Assert.assertTrue((boolean)readResponse.getResponseTypes().containsAll(expectedResponseTypes));
        Assert.assertNotNull((Object)readResponse.getGrantTypes());
        Assert.assertTrue((boolean)readResponse.getGrantTypes().containsAll(expectedGrantTypes));
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(expectedResponseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        if (expectedResponseTypes.size() == 0) {
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = authorizeClient.exec();
            GrantTypesRestrictionHttpTest.showClient((BaseClient)authorizeClient);
            Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302);
            Assert.assertNotNull((Object)authorizationResponse.getLocation());
            Assert.assertNotNull((Object)authorizationResponse.getErrorType());
            Assert.assertNotNull((Object)authorizationResponse.getErrorDescription());
            Assert.assertNotNull((Object)authorizationResponse.getState());
            return;
        }
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        String scope = authorizationResponse.getScope();
        String authorizationCode = null;
        String accessToken = null;
        String idToken = null;
        String refreshToken = null;
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertNotNull((Object)authorizationResponse.getScope());
        if (expectedResponseTypes.contains(ResponseType.CODE)) {
            Assert.assertNotNull((Object)authorizationResponse.getCode());
            authorizationCode = authorizationResponse.getCode();
        }
        if (expectedResponseTypes.contains(ResponseType.TOKEN)) {
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken());
            accessToken = authorizationResponse.getAccessToken();
        }
        if (expectedResponseTypes.contains(ResponseType.ID_TOKEN)) {
            Assert.assertNotNull((Object)authorizationResponse.getIdToken());
            idToken = authorizationResponse.getIdToken();
            Jwt jwt = Jwt.parse((String)idToken);
            Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
            RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
            RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
            Assert.assertTrue((boolean)rsaSigner.validate(jwt));
            if (expectedResponseTypes.contains(ResponseType.CODE)) {
                Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
                Assert.assertTrue((boolean)rsaSigner.validateAuthorizationCode(authorizationCode, jwt));
            }
            if (expectedResponseTypes.contains(ResponseType.TOKEN)) {
                Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("at_hash"));
                Assert.assertTrue((boolean)rsaSigner.validateAccessToken(accessToken, jwt));
            }
        }
        if (expectedResponseTypes.contains(ResponseType.CODE)) {
            TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
            tokenRequest.setCode(authorizationCode);
            tokenRequest.setRedirectUri(redirectUri);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
            TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
            tokenClient.setRequest((BaseRequest)tokenRequest);
            TokenResponse tokenResponse = tokenClient.exec();
            GrantTypesRestrictionHttpTest.showClient((BaseClient)tokenClient);
            Assert.assertEquals((int)tokenResponse.getStatus(), (int)200);
            Assert.assertNotNull((Object)tokenResponse.getEntity());
            Assert.assertNotNull((Object)tokenResponse.getAccessToken());
            Assert.assertNotNull((Object)tokenResponse.getExpiresIn());
            Assert.assertNotNull((Object)tokenResponse.getTokenType());
            if (expectedGrantTypes.contains(GrantType.REFRESH_TOKEN)) {
                Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
                refreshToken = tokenResponse.getRefreshToken();
                TokenClient refreshTokenClient = new TokenClient(this.tokenEndpoint);
                TokenResponse refreshTokenResponse = refreshTokenClient.execRefreshToken(scope, refreshToken, clientId, clientSecret);
                GrantTypesRestrictionHttpTest.showClient((BaseClient)refreshTokenClient);
                Assert.assertEquals((int)refreshTokenResponse.getStatus(), (int)200);
                Assert.assertNotNull((Object)refreshTokenResponse.getEntity());
                Assert.assertNotNull((Object)refreshTokenResponse.getAccessToken());
                Assert.assertNotNull((Object)refreshTokenResponse.getTokenType());
                Assert.assertNotNull((Object)refreshTokenResponse.getRefreshToken());
                Assert.assertNotNull((Object)refreshTokenResponse.getScope());
                accessToken = refreshTokenResponse.getAccessToken();
            } else {
                Assert.assertNull((Object)tokenResponse.getRefreshToken());
            }
        }
        if (accessToken != null) {
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
            GrantTypesRestrictionHttpTest.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200);
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("address"));
            if (idToken != null) {
                String endSessionId = UUID.randomUUID().toString();
                EndSessionRequest endSessionRequest = new EndSessionRequest(idToken, postLogoutRedirectUri, endSessionId);
                endSessionRequest.setSessionId(authorizationResponse.getSessionId());
                EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
                endSessionClient.setRequest((BaseRequest)endSessionRequest);
                EndSessionResponse endSessionResponse = endSessionClient.exec();
                GrantTypesRestrictionHttpTest.showClient((BaseClient)endSessionClient);
                Assert.assertEquals((int)endSessionResponse.getStatus(), (int)200);
                Assert.assertNotNull((Object)endSessionResponse.getHtmlPage());
                Assert.assertTrue((boolean)endSessionResponse.getHtmlPage().contains("<html>"));
                Assert.assertTrue((boolean)endSessionResponse.getHtmlPage().contains(logoutUri));
                Assert.assertTrue((boolean)endSessionResponse.getHtmlPage().contains(postLogoutRedirectUri));
            }
        }
    }

    @DataProvider(name="grantTypesRestrictionDataProvider")
    public Object[][] omittedResponseTypesFailDataProvider(ITestContext context) {
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUris = context.getCurrentXmlTest().getParameter("redirectUris");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        String sectorIdentifierUri = context.getCurrentXmlTest().getParameter("sectorIdentifierUri");
        String postLogoutRedirectUri = context.getCurrentXmlTest().getParameter("postLogoutRedirectUri");
        String logoutUri = context.getCurrentXmlTest().getParameter("logoutUri");
        return new Object[][]{{Arrays.asList(new Object[0]), Arrays.asList(ResponseType.CODE), Arrays.asList(new Object[0]), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE), Arrays.asList(new Object[0]), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.TOKEN), Arrays.asList(new Object[0]), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(new Object[0]), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(new Object[0]), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(new Object[0]), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(new Object[0]), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(new Object[0]), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(ResponseType.CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(ResponseType.TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(new Object[0]), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(new Object[0]), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(new Object[0]), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(new Object[0]), Arrays.asList(new Object[0]), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE), Arrays.asList(ResponseType.CODE), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.TOKEN), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.IMPLICIT, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.TOKEN), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.IMPLICIT, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN), Arrays.asList(ResponseType.TOKEN), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.IMPLICIT, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.IMPLICIT, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.IMPLICIT, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(ResponseType.ID_TOKEN), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.IMPLICIT, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.IMPLICIT, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.IMPLICIT, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.IMPLICIT, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.REFRESH_TOKEN), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.CLIENT_CREDENTIALS), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.CLIENT_CREDENTIALS), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}, {Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN), Arrays.asList(GrantType.OXAUTH_UMA_TICKET), Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.IMPLICIT, GrantType.OXAUTH_UMA_TICKET), userId, userSecret, redirectUris, redirectUri, sectorIdentifierUri, postLogoutRedirectUri, logoutUri}};
    }
}

