/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.EndSessionClient;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.util.StringUtils;

public class EndSessionRestWebServiceHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "postLogoutRedirectUri", "logoutUri", "sectorIdentifierUri"})
    @Test
    public void requestEndSession(String userId, String userSecret, String redirectUri, String redirectUris, String postLogoutRedirectUri, String logoutUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestEndSession by id_token");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setFrontChannelLogoutUris((List)Lists.newArrayList((Object[])new String[]{logoutUri}));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertEquals((String)authorizationResponse.getState(), (String)state);
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getSessionId(), (String)"The session_id is null");
        String idToken = authorizationResponse.getIdToken();
        String endSessionId1 = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest1 = new EndSessionRequest(idToken, postLogoutRedirectUri, endSessionId1);
        endSessionRequest1.setSessionId(authorizationResponse.getSessionId());
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        endSessionClient.setRequest((BaseRequest)endSessionRequest1);
        EndSessionResponse endSessionResponse1 = endSessionClient.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)endSessionResponse1.getStatus(), (int)200);
        Assert.assertNotNull((Object)endSessionResponse1.getHtmlPage(), (String)"The HTML page is null");
        Assert.assertTrue((boolean)endSessionResponse1.getHtmlPage().contains("<html>"), (String)"The HTML page is null");
        Assert.assertTrue((boolean)endSessionResponse1.getHtmlPage().contains(logoutUri), (String)"logout_uri is not present on html page");
        Assert.assertTrue((boolean)endSessionResponse1.getHtmlPage().contains(postLogoutRedirectUri), (String)"postLogoutRedirectUri is not present on html page");
        String endSessionId2 = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest2 = new EndSessionRequest(idToken, postLogoutRedirectUri, endSessionId2);
        endSessionRequest2.setSessionId(authorizationResponse.getSessionId());
        EndSessionClient endSessionClient2 = new EndSessionClient(this.endSessionEndpoint);
        endSessionClient2.setRequest((BaseRequest)endSessionRequest2);
        EndSessionResponse endSessionResponse2 = endSessionClient2.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient2);
        Assert.assertEquals((int)endSessionResponse2.getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        Assert.assertEquals((Object)endSessionResponse2.getErrorType(), (Object)EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION);
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "postLogoutRedirectUri", "logoutUri", "sectorIdentifierUri"})
    @Test
    public void requestEndSessionWithSessionId(String userId, String userSecret, String redirectUri, String redirectUris, String postLogoutRedirectUri, String logoutUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestEndSession by session_id");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setFrontChannelLogoutUris((List)Lists.newArrayList((Object[])new String[]{logoutUri}));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertEquals((String)authorizationResponse.getState(), (String)state);
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getSessionId(), (String)"The session_id is null");
        String endSessionId1 = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest1 = new EndSessionRequest(null, postLogoutRedirectUri, endSessionId1);
        endSessionRequest1.setSessionId(authorizationResponse.getSessionId());
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        endSessionClient.setRequest((BaseRequest)endSessionRequest1);
        EndSessionResponse endSessionResponse1 = endSessionClient.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)endSessionResponse1.getStatus(), (int)200);
        Assert.assertNotNull((Object)endSessionResponse1.getHtmlPage(), (String)"The HTML page is null");
        Assert.assertTrue((boolean)endSessionResponse1.getHtmlPage().contains("<html>"), (String)"The HTML page is null");
        Assert.assertTrue((boolean)endSessionResponse1.getHtmlPage().contains(logoutUri), (String)"logout_uri is not present on html page");
        Assert.assertTrue((boolean)endSessionResponse1.getHtmlPage().contains(postLogoutRedirectUri), (String)"postLogoutRedirectUri is not present on html page");
        String endSessionId2 = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest2 = new EndSessionRequest(null, postLogoutRedirectUri, endSessionId2);
        endSessionRequest2.setSessionId(authorizationResponse.getSessionId());
        EndSessionClient endSessionClient2 = new EndSessionClient(this.endSessionEndpoint);
        endSessionClient2.setRequest((BaseRequest)endSessionRequest2);
        EndSessionResponse endSessionResponse2 = endSessionClient2.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient2);
        Assert.assertEquals((int)endSessionResponse2.getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        Assert.assertEquals((Object)endSessionResponse2.getErrorType(), (Object)EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION);
    }

    @Test
    public void requestEndSessionFail1() throws Exception {
        this.showTitle("requestEndSessionFail1");
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        EndSessionResponse response = endSessionClient.execEndSession(null, null, null);
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"postLogoutRedirectUri"})
    @Test
    public void requestEndSessionFail2(String postLogoutRedirectUri) throws Exception {
        this.showTitle("requestEndSessionFail2");
        String state = UUID.randomUUID().toString();
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        EndSessionResponse response = endSessionClient.execEndSession("INVALID_ACCESS_TOKEN", postLogoutRedirectUri, state);
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode(), (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }
}

