/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.model.JwtState;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.StringUtils;

public class EncodeClaimsInStateParameter
extends BaseTest {
    private final String additionalClaims = "{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}";

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void encodeClaimsInStateParameterHS256(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, clientSecret, SignatureAlgorithm.HS256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void encodeClaimsInStateParameterHS384(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterHS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS384, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, clientSecret, SignatureAlgorithm.HS384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void encodeClaimsInStateParameterHS512(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS512, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, clientSecret, SignatureAlgorithm.HS512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId"})
    @Test
    public void encodeClaimsInStateParameterRS256(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("encodeClaimsInStateParameterRS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.RS256, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.RS256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "RS384_keyId"})
    @Test
    public void encodeClaimsInStateParameterRS384(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("encodeClaimsInStateParameterRS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.RS384, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.RS384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "RS512_keyId"})
    @Test
    public void encodeClaimsInStateParameterRS512(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("encodeClaimsInStateParameterRS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.RS512, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.RS512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "ES256_keyId"})
    @Test
    public void encodeClaimsInStateParameterES256(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("encodeClaimsInStateParameterES256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.ES256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "ES384_keyId"})
    @Test
    public void encodeClaimsInStateParameterES384(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("encodeClaimsInStateParameterES384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.ES384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "ES512_keyId"})
    @Test
    public void encodeClaimsInStateParameterES512(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("encodeClaimsInStateParameterES512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwt jwt = Jwt.parse((String)state);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.ES512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId", "clientJwksUri"})
    @Test
    public void encodeClaimsInStateParameterAlgRSAOAEPEncA256GCM(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId, String clientJwksUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterAlgRSAOAEPEncA256GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        JSONObject jwks = JwtUtil.getJSONWebKeys((String)clientJwksUri);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.RSA_OAEP, BlockEncryptionAlgorithm.A256GCM, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt(jwks);
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
        Jwe jwe = Jwe.parse((String)state, (PrivateKey)privateKey, null);
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("kid"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId", "clientJwksUri"})
    @Test
    public void encodeClaimsInStateParameterAlgRSA15EncA128CBCPLUSHS256(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId, String clientJwksUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterAlgRSA15EncA128CBCPLUSHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        JSONObject jwks = JwtUtil.getJSONWebKeys((String)clientJwksUri);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A128CBC_PLUS_HS256, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt(jwks);
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
        Jwe jwe = Jwe.parse((String)state, (PrivateKey)privateKey, null);
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("kid"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri", "keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId", "clientJwksUri"})
    @Test
    public void encodeClaimsInStateParameterAlgRSA15EncA256CBCPLUSHS512(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri, String keyStoreFile, String keyStoreSecret, String dnName, String keyId, String clientJwksUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterAlgRSA15EncA256CBCPLUSHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        JSONObject jwks = JwtUtil.getJSONWebKeys((String)clientJwksUri);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A256CBC_PLUS_HS512, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt(jwks);
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
        Jwe jwe = Jwe.parse((String)state, (PrivateKey)privateKey, null);
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("kid"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void encodeClaimsInStateParameterAlgA128KWEncA128GCM(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterAlgA128KWEncA128GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.A128KW, BlockEncryptionAlgorithm.A128GCM, clientSecret);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwe jwe = Jwe.parse((String)state, null, (byte[])clientSecret.getBytes());
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void encodeClaimsInStateParameterAlgA256KWEncA256GCM(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("encodeClaimsInStateParameterAlgA256KWEncA256GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        EncodeClaimsInStateParameter.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.A256KW, BlockEncryptionAlgorithm.A256GCM, clientSecret);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(encodedState);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String state = authorizationResponse.getState();
        Jwe jwe = Jwe.parse((String)state, null, (byte[])clientSecret.getBytes());
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Test
    public void jwtStateNONETest() throws Exception {
        this.showTitle("jwtStateNONETest");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.NONE, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Encoded State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, null, SignatureAlgorithm.NONE);
        Assert.assertTrue((boolean)validJwt);
    }

    @Test
    public void jwtStateHS256Test() throws Exception {
        this.showTitle("jwtStateHS256Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        String sharedKey = "shared_key";
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS256, sharedKey, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, sharedKey, SignatureAlgorithm.HS256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Test
    public void jwtStateHS384Test() throws Exception {
        this.showTitle("jwtStateHS384Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        String sharedKey = "shared_key";
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS384, sharedKey, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, sharedKey, SignatureAlgorithm.HS384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Test
    public void jwtStateHS512Test() throws Exception {
        this.showTitle("jwtStateHS512Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        String sharedKey = "shared_key";
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.HS512, sharedKey, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, sharedKey, SignatureAlgorithm.HS512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId"})
    @Test
    public void jwtStateRS256Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("jwtStateRS256Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.RS256, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.RS256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "RS384_keyId"})
    @Test
    public void jwtStateRS384Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("jwtStateRS384Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.RS384, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.RS384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "RS512_keyId"})
    @Test
    public void jwtStateRS512Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("jwtStateRS512Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.RS512, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.RS512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "ES256_keyId"})
    @Test
    public void jwtStateES256Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("jwtStateES256Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.ES256);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "ES384_keyId"})
    @Test
    public void jwtStateES384Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("jwtStateES384Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.ES384);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "ES512_keyId"})
    @Test
    public void jwtStateES512Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId) throws Exception {
        this.showTitle("jwtStateES512Test");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Signed JWS State: " + encodedState);
        Jwt jwt = Jwt.parse((String)encodedState);
        boolean validJwt = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, null, null, SignatureAlgorithm.ES512);
        Assert.assertTrue((boolean)validJwt);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId", "clientJwksUri"})
    @Test
    public void jwtStateAlgRSAOAEPEncA256GCMTest(String keyStoreFile, String keyStoreSecret, String dnName, String keyId, String clientJwksUri) throws Exception {
        this.showTitle("jwtStateAlgRSAOAEPEncA256GCMTest");
        JSONObject jwks = JwtUtil.getJSONWebKeys((String)clientJwksUri);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.RSA_OAEP, BlockEncryptionAlgorithm.A256GCM, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt(jwks);
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Encrypted JWE State: " + encodedState);
        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
        Jwe jwe = Jwe.parse((String)encodedState, (PrivateKey)privateKey, null);
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("kid"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId", "clientJwksUri"})
    @Test
    public void jwtStateAlgRSA15EncA128CBCPLUSHS256Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId, String clientJwksUri) throws Exception {
        this.showTitle("jwtStateAlgRSA15EncA128CBCPLUSHS256Test");
        JSONObject jwks = JwtUtil.getJSONWebKeys((String)clientJwksUri);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A128CBC_PLUS_HS256, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt(jwks);
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Encrypted JWE State: " + encodedState);
        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
        Jwe jwe = Jwe.parse((String)encodedState, (PrivateKey)privateKey, null);
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("kid"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Parameters(value={"keyStoreFile", "keyStoreSecret", "dnName", "RS256_keyId", "clientJwksUri"})
    @Test
    public void jwtStateAlgRSA15EncA256CBCPLUSHS512Test(String keyStoreFile, String keyStoreSecret, String dnName, String keyId, String clientJwksUri) throws Exception {
        this.showTitle("jwtStateAlgRSA15EncA256CBCPLUSHS512Test");
        JSONObject jwks = JwtUtil.getJSONWebKeys((String)clientJwksUri);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A256CBC_PLUS_HS512, (AbstractCryptoProvider)cryptoProvider);
        jwtState.setKeyId(keyId);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt(jwks);
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Encrypted JWE State: " + encodedState);
        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
        Jwe jwe = Jwe.parse((String)encodedState, (PrivateKey)privateKey, null);
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("kid"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Test
    public void jwtStateAlgA128KWEncA128GCMTest() throws Exception {
        this.showTitle("jwtStateAlgA128KWEncA128GCMTest");
        String sharedKey = "shared_key";
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.A128KW, BlockEncryptionAlgorithm.A128GCM, sharedKey);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Encrypted JWE State: " + encodedState);
        Jwe jwe = Jwe.parse((String)encodedState, null, (byte[])sharedKey.getBytes());
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }

    @Test
    public void jwtStateAlgA256KWEncA256GCMTest() throws Exception {
        this.showTitle("jwtStateAlgA256KWEncA256GCMTest");
        String sharedKey = "shared_key";
        String rfp = UUID.randomUUID().toString();
        String jti = UUID.randomUUID().toString();
        JwtState jwtState = new JwtState(KeyEncryptionAlgorithm.A256KW, BlockEncryptionAlgorithm.A256GCM, sharedKey);
        jwtState.setRfp(rfp);
        jwtState.setJti(jti);
        jwtState.setAdditionalClaims(new JSONObject("{first_name: 'Javier', last_name: 'Rojas', age: 34, more: ['foo', 'bar']}"));
        String encodedState = jwtState.getEncodedJwt();
        Assert.assertNotNull((Object)encodedState);
        System.out.println("Encrypted JWE State: " + encodedState);
        Jwe jwe = Jwe.parse((String)encodedState, null, (byte[])sharedKey.getBytes());
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("rfp"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("jti"));
        Assert.assertNotNull((Object)jwe.getClaims().getClaimAsJSON("additional_claims"));
        JSONObject addClaims = jwe.getClaims().getClaimAsJSON("additional_claims");
        Assert.assertEquals((String)addClaims.getString("first_name"), (String)"Javier");
        Assert.assertEquals((String)addClaims.getString("last_name"), (String)"Rojas");
        Assert.assertEquals((int)addClaims.getInt("age"), (int)34);
        Assert.assertNotNull((Object)addClaims.getJSONArray("more"));
        Assert.assertEquals((int)addClaims.getJSONArray("more").length(), (int)2);
    }
}

