/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.apache.http.client.HttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConfigurationClient;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryResponse;
import org.xdi.oxauth.dev.HostnameVerifierType;
import org.xdi.oxauth.model.discovery.WebFingerLink;

public class ConfigurationRestWebServiceHttpTest
extends BaseTest {
    @Test
    @Parameters(value={"swdResource"})
    public void requestOpenIdConfiguration(String resource) throws Exception {
        this.showTitle("OpenID Connect Discovery");
        OpenIdConnectDiscoveryClient openIdConnectDiscoveryClient = new OpenIdConnectDiscoveryClient(resource);
        OpenIdConnectDiscoveryResponse openIdConnectDiscoveryResponse = openIdConnectDiscoveryClient.exec((ClientExecutor)new ApacheHttpClient4Executor((HttpClient)ConfigurationRestWebServiceHttpTest.createHttpClient(HostnameVerifierType.ALLOW_ALL)));
        ConfigurationRestWebServiceHttpTest.showClient((BaseClient)openIdConnectDiscoveryClient);
        Assert.assertEquals((int)openIdConnectDiscoveryResponse.getStatus(), (int)200, (String)"Unexpected response code");
        Assert.assertNotNull((Object)openIdConnectDiscoveryResponse.getSubject());
        Assert.assertTrue((openIdConnectDiscoveryResponse.getLinks().size() > 0 ? 1 : 0) != 0);
        String configurationEndpoint = ((WebFingerLink)openIdConnectDiscoveryResponse.getLinks().get(0)).getHref() + "/.well-known/openid-configuration";
        this.showTitle("OpenID Connect Configuration");
        OpenIdConfigurationClient client = new OpenIdConfigurationClient(configurationEndpoint);
        OpenIdConfigurationResponse response = client.execOpenIdConfiguration();
        ConfigurationRestWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code");
        Assert.assertNotNull((Object)response.getIssuer(), (String)"The issuer is null");
        Assert.assertNotNull((Object)response.getAuthorizationEndpoint(), (String)"The authorizationEndpoint is null");
        Assert.assertNotNull((Object)response.getTokenEndpoint(), (String)"The tokenEndpoint is null");
        Assert.assertNotNull((Object)response.getUserInfoEndpoint(), (String)"The userInfoEndPoint is null");
        Assert.assertNotNull((Object)response.getClientInfoEndpoint(), (String)"The clientInfoEndPoint is null");
        Assert.assertNotNull((Object)response.getCheckSessionIFrame(), (String)"The checkSessionIFrame is null");
        Assert.assertNotNull((Object)response.getEndSessionEndpoint(), (String)"The endSessionEndpoint is null");
        Assert.assertNotNull((Object)response.getJwksUri(), (String)"The jwksUri is null");
        Assert.assertNotNull((Object)response.getRegistrationEndpoint(), (String)"The registrationEndpoint is null");
        Assert.assertNotNull((Object)response.getIntrospectionEndpoint(), (String)"The introspectionEndpoint is null");
        Assert.assertNotNull((Object)response.getIdGenerationEndpoint(), (String)"The idGenerationEndpoint is null");
        Assert.assertTrue((response.getScopesSupported().size() > 0 ? 1 : 0) != 0, (String)"The scopesSupported is empty");
        Assert.assertTrue((response.getScopeToClaimsMapping().size() > 0 ? 1 : 0) != 0, (String)"The scope to claims mapping is empty");
        Assert.assertTrue((response.getResponseTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The responseTypesSupported is empty");
        Assert.assertTrue((response.getGrantTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The grantTypesSupported is empty");
        Assert.assertTrue((response.getAcrValuesSupported().size() >= 0 ? 1 : 0) != 0, (String)"The acrValuesSupported is empty");
        Assert.assertTrue((response.getSubjectTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The subjectTypesSupported is empty");
        Assert.assertTrue((response.getUserInfoSigningAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The userInfoSigningAlgValuesSupported is empty");
        Assert.assertTrue((response.getUserInfoEncryptionAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The userInfoEncryptionAlgValuesSupported is empty");
        Assert.assertTrue((response.getUserInfoEncryptionEncValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The userInfoEncryptionEncValuesSupported is empty");
        Assert.assertTrue((response.getIdTokenSigningAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The idTokenSigningAlgValuesSupported is empty");
        Assert.assertTrue((response.getIdTokenEncryptionAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The idTokenEncryptionAlgValuesSupported is empty");
        Assert.assertTrue((response.getIdTokenEncryptionEncValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The idTokenEncryptionEncValuesSupported is empty");
        Assert.assertTrue((response.getRequestObjectSigningAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The requestObjectSigningAlgValuesSupported is empty");
        Assert.assertTrue((response.getRequestObjectEncryptionAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The requestObjectEncryptionAlgValuesSupported is empty");
        Assert.assertTrue((response.getRequestObjectEncryptionEncValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The requestObjectEncryptionEncValuesSupported is empty");
        Assert.assertTrue((response.getTokenEndpointAuthMethodsSupported().size() > 0 ? 1 : 0) != 0, (String)"The tokenEndpointAuthMethodsSupported is empty");
        Assert.assertTrue((response.getTokenEndpointAuthSigningAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The tokenEndpointAuthSigningAlgValuesSupported is empty");
        Assert.assertTrue((response.getDisplayValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The displayValuesSupported is empty");
        Assert.assertTrue((response.getClaimTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The claimTypesSupported is empty");
        Assert.assertTrue((response.getClaimsSupported().size() > 0 ? 1 : 0) != 0, (String)"The claimsSupported is empty");
        Assert.assertNotNull((Object)response.getServiceDocumentation(), (String)"The serviceDocumentation is null");
        Assert.assertTrue((response.getClaimsLocalesSupported().size() > 0 ? 1 : 0) != 0, (String)"The claimsLocalesSupported is empty");
        Assert.assertTrue((response.getUiLocalesSupported().size() > 0 ? 1 : 0) != 0, (String)"The uiLocalesSupported is empty");
        Assert.assertTrue((boolean)response.getClaimsParameterSupported(), (String)"The claimsParameterSupported is false");
        Assert.assertTrue((boolean)response.getRequestParameterSupported(), (String)"The requestParameterSupported is false");
        Assert.assertTrue((boolean)response.getRequestUriParameterSupported(), (String)"The requestUriParameterSupported is false");
        Assert.assertFalse((boolean)response.getRequireRequestUriRegistration(), (String)"The requireRequestUriRegistration is true");
        Assert.assertNotNull((Object)response.getOpPolicyUri(), (String)"The opPolicyUri is null");
        Assert.assertNotNull((Object)response.getOpTosUri(), (String)"The opTosUri is null");
    }
}

