/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.model.util.URLPatternList;

public class ClientWhiteListBlackListRedirectUris
extends BaseTest {
    private String registrationAccessToken1;
    private String registrationClientUri1;

    @Test
    public void testUrlPatterList() {
        this.showTitle("testUrlPatterList");
        List<String> urlPatterns = Arrays.asList("*.gluu.org/foo*bar", "https://example.org/foo/bar.html", "*.attacker.com/*");
        URLPatternList urlPatternList = new URLPatternList(urlPatterns);
        Assert.assertFalse((boolean)urlPatternList.isUrlListed("gluu.org"));
        Assert.assertFalse((boolean)urlPatternList.isUrlListed("www.gluu.org"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("http://gluu.org/foo/bar"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("https://mail.gluu.org/foo/bar"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("http://www.gluu.org/foobar"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("https://www.gluu.org/foo/baz/bar"));
        Assert.assertFalse((boolean)urlPatternList.isUrlListed("http://example.org"));
        Assert.assertFalse((boolean)urlPatternList.isUrlListed("http://example.org/foo/bar.html"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("https://example.org/foo/bar.html"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("http://attacker.com"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("https://www.attacker.com"));
        Assert.assertTrue((boolean)urlPatternList.isUrlListed("https://www.attacker.com/foo/bar"));
    }

    @Test
    public void requestClientAssociateInBlackList() throws Exception {
        this.showTitle("requestClientAssociateInBlackList");
        String redirectUris = "https://www.attacker.com";
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)"https://www.attacker.com"));
        ClientWhiteListBlackListRedirectUris.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestClientAssociate(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestClientAssociate");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(ClientWhiteListBlackListRedirectUris.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        ClientWhiteListBlackListRedirectUris.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        this.registrationAccessToken1 = response.getRegistrationAccessToken();
        this.registrationClientUri1 = response.getRegistrationClientUri();
    }

    @Test(dependsOnMethods={"requestClientAssociate"})
    public void requestClientUpdate() throws Exception {
        this.showTitle("requestClientUpdate");
        String redirectUris = "https://www.attacker.com";
        RegisterRequest registerRequest = new RegisterRequest(this.registrationAccessToken1);
        registerRequest.setHttpMethod("PUT");
        registerRequest.setRedirectUris(StringUtils.spaceSeparatedToList((String)"https://www.attacker.com"));
        RegisterClient registerClient = new RegisterClient(this.registrationClientUri1);
        registerClient.setRequest((BaseRequest)registerRequest);
        registerClient.setExecutor(ClientWhiteListBlackListRedirectUris.clientExecutor(true));
        RegisterResponse response = registerClient.exec();
        ClientWhiteListBlackListRedirectUris.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }
}

