/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.ClientInfoClient;
import org.xdi.oxauth.client.ClientInfoResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.token.TokenErrorResponseType;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.xdi.oxauth.model.util.StringUtils;

public class ClientCredentialsGrantHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void defaultAuthenticationMethod(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("defaultAuthenticationMethod");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void defaultAuthenticationMethodFail(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("defaultAuthenticationMethodFail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword("INVALID_CLIENT_SECRET");
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretBasicAuthenticationMethod(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretBasicAuthenticationMethod");
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)403);
        Assert.assertEquals((Object)userInfoResponse.getErrorType(), (Object)UserInfoErrorResponseType.INSUFFICIENT_SCOPE);
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretBasicAuthenticationMethodFail(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretBasicAuthenticationMethodFail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword("INVALID_CLIENT_SECRET");
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretPostAuthenticationMethod(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretPostAuthenticationMethod");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretPostAuthenticationMethodFail1(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretPostAuthenticationMethodFail1");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword("INVALID_CLIENT_SECRET");
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretPostAuthenticationMethodFail2(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretPostAuthenticationMethodFail2");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(null);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretPostAuthenticationMethodFail3(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretPostAuthenticationMethodFail3");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(null);
        tokenRequest.setAuthPassword(null);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretJwtAuthenticationMethodHS256(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretJwtAuthenticationMethodHS256");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretJwtAuthenticationMethodHS256Fail(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretJwtAuthenticationMethodHS256Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword("INVALID_CLIENT_SECRET");
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretJwtAuthenticationMethodHS384(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretJwtAuthenticationMethodHS384");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretJwtAuthenticationMethodHS384Fail(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretJwtAuthenticationMethodHS384Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword("INVALID_CLIENT_SECRET");
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretJwtAuthenticationMethodHS512(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretJwtAuthenticationMethodHS512");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void clientSecretJwtAuthenticationMethodHS512Fail(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("clientSecretJwtAuthenticationMethodHS512Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword("INVALID_CLIENT_SECRET");
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodRS256(String redirectUris, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodRS256");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodRS256Fail(String redirectUris, String clientJwksUri, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodRS256Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId("RS256SIG_INVALID_KEYID");
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "RS384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodRS384(String redirectUris, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodRS384");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodRS384Fail(String redirectUris, String clientJwksUri, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodRS384Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId("RS384SIG_INVALID_KEYID");
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "RS512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodRS512(String redirectUris, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodRS512");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodRS512Fail(String redirectUris, String clientJwksUri, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodRS512Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId("RS512SIG_INVALID_KEYID");
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodES256(String redirectUris, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodES256");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodES256Fail(String redirectUris, String clientJwksUri, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodES256Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId("ES256SIG_INVALID_KEYID");
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodES384(String redirectUris, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodES384");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodES384Fail(String redirectUris, String clientJwksUri, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodES384Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES384);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId("ES384SIG_INVALID_KEYID");
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodES512(String redirectUris, String clientJwksUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodES512");
        List<String> scopes = Arrays.asList("clientinfo");
        List<GrantType> grantTypes = Arrays.asList(GrantType.CLIENT_CREDENTIALS);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity());
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getTokenType());
        Assert.assertNotNull((Object)tokenResponse.getScope());
        Assert.assertNull((Object)tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientCredentialsGrantHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
    }

    @Parameters(value={"redirectUris", "clientJwksUri", "dnName", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void privateKeyJwtAuthenticationMethodES512Fail(String redirectUris, String clientJwksUri, String dnName, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("privateKeyJwtAuthenticationMethodES512Fail");
        List<String> scopes = Arrays.asList("clientinfo");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setScope(scopes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.ES512);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId("ES512SIG_INVALID_KEYID");
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        ClientCredentialsGrantHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType());
        Assert.assertEquals((Object)tokenResponse.getErrorType(), (Object)TokenErrorResponseType.INVALID_CLIENT);
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription());
    }
}

