/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class AuthorizationCodeFlowHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationCodeFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationCodeFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "phone", "user_name");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, scopes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String nonce = UUID.randomUUID().toString();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, scopes, clientId, nonce);
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String refreshToken = tokenResponse1.getRefreshToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse2.getScope(), (String)"The scope is null");
        String accessToken = tokenResponse2.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("birthdate"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("gender"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("middle_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("nickname"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("preferred_username"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("profile"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("website"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email_verified"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("phone_number"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("phone_number_verified"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("address"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("user_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("org_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("work_phone"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationCodeFlowNegativeTest(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationCodeFlowNegativeTest");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> registerScopes = Arrays.asList("openid");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, registerScopes, sectorIdentifierUri);
        Assert.assertTrue((boolean)registerResponse.getClaims().containsKey(RegisterRequestParam.SCOPE.toString()));
        Assert.assertNotNull(registerResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        Assert.assertEquals((String)((String)registerResponse.getClaims().get(RegisterRequestParam.SCOPE.toString())), (String)"openid");
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String nonce = UUID.randomUUID().toString();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "phone", "user_name");
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, scopes, clientId, nonce);
        Assert.assertEquals((String)authorizationResponse.getScope(), (String)"openid");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String refreshToken = tokenResponse1.getRefreshToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse2.getScope(), (String)"The scope is null");
        Assert.assertEquals((String)tokenResponse2.getScope(), (String)"openid");
        String accessToken = tokenResponse2.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("birthdate"));
        Assert.assertNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("gender"));
        Assert.assertNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("middle_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("nickname"));
        Assert.assertNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNull((Object)userInfoResponse.getClaim("preferred_username"));
        Assert.assertNull((Object)userInfoResponse.getClaim("profile"));
        Assert.assertNull((Object)userInfoResponse.getClaim("website"));
        Assert.assertNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNull((Object)userInfoResponse.getClaim("email_verified"));
        Assert.assertNull((Object)userInfoResponse.getClaim("phone_number"));
        Assert.assertNull((Object)userInfoResponse.getClaim("phone_number_verified"));
        Assert.assertNull((Object)userInfoResponse.getClaim("address"));
        Assert.assertNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNull((Object)userInfoResponse.getClaim("user_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("org_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("work_phone"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationCodeWithNotAllowedScopeFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationCodeWithNotAllowedScopeFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "user_name");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, scopes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> authorizationScopes = Arrays.asList("openid", "profile", "address", "email", "user_name", "mobile_phone");
        String nonce = UUID.randomUUID().toString();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, authorizationScopes, clientId, nonce);
        String idToken = authorizationResponse.getIdToken();
        String authorizationCode = authorizationResponse.getCode();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        String accessToken = tokenResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("user_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("phone_mobile_number"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationCodeDynamicScopeFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationCodeDynamicScopeFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "user_name", "org_name", "work_phone");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, scopes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String nonce = UUID.randomUUID().toString();
        AuthorizationResponse authorizationResponse = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, scopes, clientId, nonce);
        String idToken = authorizationResponse.getIdToken();
        String authorizationCode = authorizationResponse.getCode();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        String accessToken = tokenResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("user_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("org_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("work_phone"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationCodeFlowWithOptionalNonce(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationCodeFlowWithOptionalNonce");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String refreshToken = tokenResponse1.getRefreshToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("nonce"));
        Assert.assertEquals((String)jwt.getClaims().getClaimAsString("nonce"), (String)nonce);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse2.getScope(), (String)"The scope is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void revokeTokens(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("revokeTokens");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest((BaseRequest)readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.SCOPE.toString()));
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        TokenResponse response2 = tokenClient1.execAuthorizationCode(authorizationCode, redirectUri, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response2.getRefreshToken(), (String)"The refresh token is null");
        String accessToken = response2.getAccessToken();
        String refreshToken = response2.getRefreshToken();
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse response4 = tokenClient2.execAuthorizationCode(authorizationCode, redirectUri, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)response4.getStatus(), (int)400, (String)("Unexpected response code: " + response4.getStatus()));
        Assert.assertNotNull((Object)response4.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response4.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response4.getErrorDescription(), (String)"The error description is null");
        TokenClient tokenClient3 = new TokenClient(this.tokenEndpoint);
        TokenResponse response5 = tokenClient3.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient3);
        Assert.assertEquals((int)response5.getStatus(), (int)401, (String)("Unexpected response code: " + response5.getStatus()));
        Assert.assertNotNull((Object)response5.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response5.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response5.getErrorDescription(), (String)"The error description is null");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response7 = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response7.getStatus(), (int)400, (String)("Unexpected response code: " + response7.getStatus()));
        Assert.assertNotNull((Object)response7.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response7.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void authorizationCodeFlowLoginHint(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("authorizationCodeFlowLoginHint");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "user_name");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, scopes, sectorIdentifierUri);
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setLoginHint(userId);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, null, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String refreshToken = tokenResponse1.getRefreshToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse2.getScope(), (String)"The scope is null");
        String accessToken = tokenResponse2.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("user_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("org_name"));
        Assert.assertNull((Object)userInfoResponse.getClaim("work_phone"));
    }

    private AuthorizationResponse requestAuthorization(String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes, List<String> scopes, String clientId, String nonce) {
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        return authorizationResponse;
    }

    private RegisterResponse registerClient(String redirectUris, List<ResponseType> responseTypes, List<String> scopes, String sectorIdentifierUri) {
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setScope(scopes);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        return registerResponse;
    }
}

