/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.load.benchmark.suite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.xdi.util.StringHelper;

public class BenchmarkTestListener
implements ITestListener {
    private List<String> methodNames;
    private Map<String, Long> methodTakes;
    private Map<String, Long> methodInvoked;
    private Lock lock = new ReentrantLock();

    public void onTestStart(ITestResult result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestSuccess(ITestResult result) {
        String methodName = result.getMethod().getMethodName();
        long takes = result.getEndMillis() - result.getStartMillis();
        this.lock.lock();
        try {
            Long totalInvoked;
            Long totalTakes;
            if (this.methodTakes.containsKey(methodName)) {
                totalTakes = this.methodTakes.get(methodName);
                totalInvoked = this.methodInvoked.get(methodName);
                totalTakes = totalTakes + takes;
                Long l = totalInvoked;
                Long l2 = totalInvoked = Long.valueOf(totalInvoked + 1L);
            } else {
                this.methodNames.add(methodName);
                totalTakes = takes;
                totalInvoked = 1L;
            }
            this.methodTakes.put(methodName, totalTakes);
            this.methodInvoked.put(methodName, totalInvoked);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
        Reporter.log((String)("Test '" + context.getName() + "' started ..."), (boolean)true);
        this.methodNames = new ArrayList<String>();
        this.methodTakes = new HashMap<String, Long>();
        this.methodInvoked = new HashMap<String, Long>();
    }

    public void onFinish(ITestContext context) {
        long takes = (context.getEndDate().getTime() - context.getStartDate().getTime()) / 1000L;
        Reporter.log((String)("Test '" + context.getName() + "' finished in " + takes + " seconds"), (boolean)true);
        Reporter.log((String)"================================================================================", (boolean)true);
        for (String methodName : this.methodNames) {
            long methodTakes = this.methodTakes.get(methodName);
            long methodInvoked = this.methodInvoked.get(methodName);
            long methodThreads = this.getMethodThreqads(context, methodName);
            long oneExecutionMethodTakes = methodTakes == 0L ? 0L : methodTakes / methodInvoked;
            Reporter.log((String)("BENCHMARK REPORT |  Method: '" + methodName + "' | Takes:" + methodTakes + " | Invoked: " + methodInvoked + " | Threads: " + methodThreads + " | Average method execution: " + oneExecutionMethodTakes), (boolean)true);
        }
        Reporter.log((String)"================================================================================", (boolean)true);
    }

    private long getMethodThreqads(ITestContext context, String methodName) {
        ITestNGMethod[] allTestMethods = context.getAllTestMethods();
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (!StringHelper.equalsIgnoreCase((String)allTestMethods[i].getMethodName(), (String)methodName)) continue;
            return allTestMethods[i].getThreadPoolSize();
        }
        return 1L;
    }
}

