/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.load.benchmark;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.load.benchmark.suite.BenchmarkTestListener;
import org.xdi.oxauth.load.benchmark.suite.BenchmarkTestSuiteListener;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

@Listeners(value={BenchmarkTestSuiteListener.class, BenchmarkTestListener.class})
public class BenchmarkRequestAuthorization
extends BaseTest {
    private String clientId;
    private String clientSecret;

    @Parameters(value={"userId", "userSecret", "redirectUris", "sectorIdentifierUri"})
    @BeforeClass
    public void registerClient(String userId, String userSecret, String redirectUris, String sectorIdentifierUri) throws Exception {
        Reporter.log((String)"Register client", (boolean)true);
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "user_name");
        RegisterResponse registerResponse = this.registerClient(redirectUris, responseTypes, scopes, sectorIdentifierUri);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        this.clientId = registerResponse.getClientId();
        this.clientSecret = registerResponse.getClientSecret();
    }

    @Parameters(value={"userId", "userSecret", "redirectUri"})
    @Test(invocationCount=200, threadPoolSize=1)
    public void testAuthorization1(String userId, String userSecret, String redirectUri) throws Exception {
        this.testAuthorizationImpl(userId, userSecret, this.clientId, redirectUri, false);
    }

    @Parameters(value={"userId", "userSecret", "redirectUri"})
    @Test(invocationCount=200, threadPoolSize=5, dependsOnMethods={"testAuthorization1"})
    public void testAuthorization2(String userId, String userSecret, String redirectUri) throws Exception {
        this.testAuthorizationImpl(userId, userSecret, this.clientId, redirectUri, true);
    }

    @Parameters(value={"userId", "userSecret", "redirectUri"})
    @Test(invocationCount=200, threadPoolSize=2, dependsOnMethods={"testAuthorization2"})
    public void testAuthorization3(String userId, String userSecret, String redirectUri) throws Exception {
        this.testAuthorizationImpl(userId, userSecret, this.clientId, redirectUri, true);
    }

    private void testAuthorizationImpl(String userId, String userSecret, String clientId, String redirectUri, boolean useNewDriver) {
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email", "user_name");
        String nonce = UUID.randomUUID().toString();
        AuthorizationResponse response = this.requestAuthorization(userId, userSecret, redirectUri, responseTypes, scopes, clientId, nonce, useNewDriver);
        Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response.getScope(), (String)"The scope is null");
    }

    private AuthorizationResponse requestAuthorization(String userId, String userSecret, String redirectUri, List<ResponseType> responseTypes, List<String> scopes, String clientId, String nonce, boolean useNewDriver) {
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret, true, useNewDriver);
        return authorizationResponse;
    }

    private RegisterResponse registerClient(String redirectUris, List<ResponseType> responseTypes, List<String> scopes, String sectorIdentifierUri) {
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth benchmark test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setScope(scopes);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        BenchmarkRequestAuthorization.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        return registerResponse;
    }
}

