/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.load;

import java.util.ArrayList;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

public class UserInfoLoadTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "clientId", "redirectUri"})
    @Test(invocationCount=1000, threadPoolSize=100)
    public void requestUserInfoImplicitFlow(String userId, String userSecret, String clientId, String redirectUri) throws Exception {
        this.showTitle("requestUserInfoImplicitFlow");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)request);
        AuthorizationResponse response1 = authorizeClient.exec();
        UserInfoLoadTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token must be null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoLoadTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
    }
}

