/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class VerifiesCorrectCHashWhenCodeFlowUsed
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void verifiesCorrectCHashWhenCodeFlowUsed(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Verifies Correct c hash when Code Flow Used");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        VerifiesCorrectCHashWhenCodeFlowUsed.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The code is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String code = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        Assert.assertTrue((boolean)rsaSigner.validateAuthorizationCode(code, jwt));
    }
}

