/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class SupportClaimsRequestSpecifyingSubValue
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void supportClaimsRequestSpecifyingSubValueSucceed(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Support claims Request Specifying sub Value (succeed)");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        SupportClaimsRequestSpecifyingSubValue.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest1 = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest1.setState(state);
        AuthorizeClient authorizeClient1 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient1.setRequest((BaseRequest)authorizationRequest1);
        AuthorizationResponse authorizationResponse1 = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest1, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse1.getIdToken(), (String)"The ID Token is null");
        Assert.assertNotNull((Object)authorizationResponse1.getAccessToken(), (String)"The Access Token is null");
        Assert.assertNotNull((Object)authorizationResponse1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse1.getScope(), (String)"The scope is null");
        String sessionId = authorizationResponse1.getSessionId();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        AuthorizationRequest authorizationRequest2 = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest2.getPrompts().add(Prompt.NONE);
        authorizationRequest2.setState(state);
        authorizationRequest2.setSessionId(sessionId);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest2, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("given_name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("family_name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("sub", ClaimValue.createSingleValue((String)userId)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest2.setRequest(authJwt);
        AuthorizeClient authorizeClient2 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient2.setRequest((BaseRequest)authorizationRequest2);
        AuthorizationResponse authorizationResponse2 = authorizeClient2.exec();
        Assert.assertNotNull((Object)authorizationResponse2.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse2.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse2.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse2.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse2.getState(), (String)"The state is null");
        String idToken = authorizationResponse2.getIdToken();
        String accessToken = authorizationResponse2.getAccessToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("at_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        SupportClaimsRequestSpecifyingSubValue.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void supportClaimsRequestSpecifyingSubValueFail(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Support claims Request Specifying sub Value (fail)");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        SupportClaimsRequestSpecifyingSubValue.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("given_name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("family_name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("sub", ClaimValue.createSingleValue((String)"WRONG_USER_ID")));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getErrorType(), (String)"The error type is null");
        Assert.assertEquals((Object)authorizationResponse.getErrorType(), (Object)AuthorizeErrorResponseType.USER_MISMATCHED);
        Assert.assertNotNull((Object)authorizationResponse.getErrorDescription(), (String)"The error description is null");
    }
}

