/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class RejectRequestsWithoutNonceUsingImplicitFlow
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void rejectRequestsWithoutNonceUsingImplicitFlow(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Reject Requests Without nonce Using Implicit Flow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        RejectRequestsWithoutNonceUsingImplicitFlow.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.setState(state);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        RejectRequestsWithoutNonceUsingImplicitFlow.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)authorizationResponse.getErrorDescription(), (String)"The error description is null");
    }
}

