/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class ProvidingIndividuallyRequestedEssentialAndVoluntaryClaims
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void providingIndividuallyRequestedEssentialAndVoluntaryClaims(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Providing Individually Requested Essential and Voluntary Claims");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        ProvidingIndividuallyRequestedEssentialAndVoluntaryClaims.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        List<String> scopes = Arrays.asList("openid");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("name", ClaimValue.createEssential((boolean)true)));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addIdTokenClaim(new Claim("picture", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createEssential((boolean)true)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createNull()));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        String accessToken = authorizationResponse.getAccessToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("at_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        ProvidingIndividuallyRequestedEssentialAndVoluntaryClaims.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
    }
}

