/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class ProvidingAcrValues
extends BaseTest {
    @Parameters(value={"redirectUri", "clientJwksUri", "userId", "userSecret"})
    @Test
    public void providingAcrValues(String redirectUri, String jwksUri, String userId, String userSecret) throws Exception {
        this.showTitle("providingAcrValues");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT);
        List<String> contacts = Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUri));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setContacts(contacts);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse response = registerClient.exec();
        ProvidingAcrValues.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getRegistrationClientUri());
        Assert.assertNotNull((Object)response.getClientIdIssuedAt());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull((Object)response.getResponseTypes());
        Assert.assertTrue((boolean)response.getResponseTypes().containsAll(responseTypes));
        Assert.assertNotNull((Object)response.getGrantTypes());
        Assert.assertTrue((boolean)response.getGrantTypes().containsAll(grantTypes));
        String clientId = response.getClientId();
        List<String> scopes = Arrays.asList("openid");
        List<String> acrValues = Arrays.asList("basic");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAcrValues(acrValues);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertNotNull((Object)authorizationResponse.getScope());
    }
}

