/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.JwkResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class OPRegistrationJwks
extends BaseTest {
    @Parameters(value={"redirectUri", "postLogoutRedirectUri", "clientJwksUri", "userId", "userSecret", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void opRegistrationJwks(String redirectUri, String postLogoutRedirectUri, String clientJwksUri, String userId, String userSecret, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        this.showTitle("opRegistrationJwks");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<GrantType> grantTypes = Arrays.asList(GrantType.AUTHORIZATION_CODE);
        List<String> contacts = Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com");
        JwkClient jwkClient = new JwkClient(clientJwksUri);
        JwkResponse jwkResponse = jwkClient.exec();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUri));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setContacts(contacts);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwks(jwkResponse.getJwks().toString());
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OPRegistrationJwks.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getRegistrationClientUri());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        Assert.assertNotNull((Object)registerResponse.getResponseTypes());
        Assert.assertTrue((boolean)registerResponse.getResponseTypes().containsAll(responseTypes));
        Assert.assertNotNull((Object)registerResponse.getGrantTypes());
        Assert.assertTrue((boolean)registerResponse.getGrantTypes().containsAll(grantTypes));
        Assert.assertNotNull(registerResponse.getClaims().get(RegisterRequestParam.JWKS.getName()));
        Assert.assertNotNull(registerResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.getName()));
        Assert.assertEquals((String)AuthenticationMethod.PRIVATE_KEY_JWT.toString(), (String)((String)registerResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.getName())));
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertNotNull((Object)authorizationResponse.getScope());
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        OPRegistrationJwks.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUri", "postLogoutRedirectUri", "clientJwksUri", "userId", "userSecret", "RS256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test
    public void opRegistrationJwksUri(String redirectUri, String postLogoutRedirectUri, String clientJwksUri, String userId, String userSecret, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        this.showTitle("opRegistrationJwksUri");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<GrantType> grantTypes = Arrays.asList(GrantType.AUTHORIZATION_CODE);
        List<String> contacts = Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUri));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setGrantTypes(grantTypes);
        registerRequest.setContacts(contacts);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        OPRegistrationJwks.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getRegistrationClientUri());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        Assert.assertNotNull((Object)registerResponse.getResponseTypes());
        Assert.assertTrue((boolean)registerResponse.getResponseTypes().containsAll(responseTypes));
        Assert.assertNotNull((Object)registerResponse.getGrantTypes());
        Assert.assertTrue((boolean)registerResponse.getGrantTypes().containsAll(grantTypes));
        Assert.assertNotNull(registerResponse.getClaims().get(RegisterRequestParam.JWKS_URI.getName()));
        Assert.assertNotNull(registerResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.getName()));
        Assert.assertEquals((String)AuthenticationMethod.PRIVATE_KEY_JWT.toString(), (String)((String)registerResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.getName())));
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertNotNull((Object)authorizationResponse.getScope());
        String authorizationCode = authorizationResponse.getCode();
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setAudience(this.tokenEndpoint);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest((BaseRequest)tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        OPRegistrationJwks.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse.getIdToken(), (String)"The id token is null");
    }
}

