/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class CanProvideEncryptedUserInfoResponse
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedUserInfoResponseAlgA128KWEncA128GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Can Provide Encrypted UserInfo Response A128KW A128GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A128KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128GCM);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        CanProvideEncryptedUserInfoResponse.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        CanProvideEncryptedUserInfoResponse.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("region"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("street_address"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("country"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedUserInfoResponseAlgA256KWEncA256GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Can Provide Encrypted UserInfo Response A256KW A256GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A256KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        CanProvideEncryptedUserInfoResponse.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest((BaseRequest)authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        CanProvideEncryptedUserInfoResponse.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("region"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("street_address"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("country"));
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedUserInfoResponseAlgRSA15EncA128CBCPLUSHS256(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted UserInfo Response RSA1_5 A128CBC_PLUS_HS256");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128CBC_PLUS_HS256);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedUserInfoResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String accessToken = authorizationResponse.getAccessToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            userInfoClient.setPrivateKey(privateKey);
            UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
            CanProvideEncryptedUserInfoResponse.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("region"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("street_address"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("country"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedUserInfoResponseAlgRSA15EncA256CBCPLUSHS512(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted UserInfo Response RSA1_5 A256CBC_PLUS_HS512");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256CBC_PLUS_HS512);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedUserInfoResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String accessToken = authorizationResponse.getAccessToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            userInfoClient.setPrivateKey(privateKey);
            UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
            CanProvideEncryptedUserInfoResponse.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("region"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("street_address"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("country"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedUserInfoResponseAlgRSAOAEPEncA256GCM(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted UserInfo Response RSA_OAEP A256GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA_OAEP);
            registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedUserInfoResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String accessToken = authorizationResponse.getAccessToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
            userInfoClient.setPrivateKey(privateKey);
            UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
            CanProvideEncryptedUserInfoResponse.showClient((BaseClient)userInfoClient);
            Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("region"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("street_address"));
            Assert.assertNotNull((Object)userInfoResponse.getClaim("country"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }
}

