/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class CanProvideEncryptedIdTokenResponse
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedIdTokenResponseAlgA128KWEncA128GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted ID Token Response A128KW A128GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.A128KW);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A128GCM);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedIdTokenResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            String clientSecret = registerResponse.getClientSecret();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String idToken = authorizationResponse.getIdToken();
            Jwe jwe = Jwe.parse((String)idToken, null, (byte[])clientSecret.getBytes("UTF-8"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedIdTokenResponseAlgA256KWEncA256GCM(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted ID Token Response A256KW A256GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.A256KW);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedIdTokenResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            String clientSecret = registerResponse.getClientSecret();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String idToken = authorizationResponse.getIdToken();
            Jwe jwe = Jwe.parse((String)idToken, null, (byte[])clientSecret.getBytes("UTF-8"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedIdTokenResponseAlgRSA15EncA128CBCPLUSHS256(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted ID Token Response RSA1_5 A128CBC_PLUS_HS256");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A128CBC_PLUS_HS256);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedIdTokenResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String idToken = authorizationResponse.getIdToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            Jwe jwe = Jwe.parse((String)idToken, (PrivateKey)privateKey, null);
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedIdTokenResponseAlgRSA15EncA256CBCPLUSHS512(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted ID Token Response RSA1_5 A256CBC_PLUS_HS512");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A256CBC_PLUS_HS512);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedIdTokenResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String idToken = authorizationResponse.getIdToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            Jwe jwe = Jwe.parse((String)idToken, (PrivateKey)privateKey, null);
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "clientJwksUri", "RS256_enc_keyId", "keyStoreFile", "keyStoreSecret", "sectorIdentifierUri"})
    @Test
    public void canProvideEncryptedIdTokenResponseAlgRSAOAEPEncA256GCM(String userId, String userSecret, String redirectUri, String redirectUris, String jwksUri, String keyId, String keyStoreFile, String keyStoreSecret, String sectorIdentifierUri) {
        try {
            this.showTitle("OC5:FeatureTest-Can Provide Encrypted ID Token Response RSA_OAEP A256GCM");
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA_OAEP);
            registerRequest.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
            registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
            RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
            registerClient.setRequest((BaseRequest)registerRequest);
            RegisterResponse registerResponse = registerClient.exec();
            CanProvideEncryptedIdTokenResponse.showClient((BaseClient)registerClient);
            Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
            Assert.assertNotNull((Object)registerResponse.getClientId());
            Assert.assertNotNull((Object)registerResponse.getClientSecret());
            Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
            Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
            Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
            String clientId = registerResponse.getClientId();
            List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient.setRequest((BaseRequest)authorizationRequest);
            AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
            Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
            Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
            Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
            Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
            String idToken = authorizationResponse.getIdToken();
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
            PrivateKey privateKey = cryptoProvider.getPrivateKey(keyId);
            Jwe jwe = Jwe.parse((String)idToken, (PrivateKey)privateKey, null);
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("typ"));
            Assert.assertNotNull((Object)jwe.getHeader().getClaimAsString("alg"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iss"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("aud"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("exp"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("iat"));
            Assert.assertNotNull((Object)jwe.getClaims().getClaimAsString("sub"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
    }
}

