/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryRequest;

public class CanDiscoverIdentifiersUsingEMailSyntax {
    @Test
    public void emailNormalization1() throws Exception {
        String resource = "acct:joe@example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization2() throws Exception {
        String resource = "joe@example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization3() throws Exception {
        String resource = "acct:joe@example.com:8080";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization4() throws Exception {
        String resource = "joe@example.com:8080";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization5() throws Exception {
        String resource = "joe@localhost";
        String expectedHost = "localhost";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization6() throws Exception {
        String resource = "joe@localhost:8080";
        String expectedHost = "localhost:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }
}

