/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class AcceptValidAsymmetricIdTokenSignature
extends BaseTest {
    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void acceptValidAsymmetricIdTokenSignatureRS256(String redirectUris, String userId, String userSecret, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Accept Valid Asymmetric ID Token Signature RS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS256);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AcceptValidAsymmetricIdTokenSignature.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertEquals((String)authorizationResponse.getState(), (String)state);
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "postLogoutRedirectUri", "clientJwksUri"})
    @Test
    public void acceptValidAsymmetricIdTokenSignatureES256(String redirectUris, String userId, String userSecret, String redirectUri, String postLogoutRedirectUri, String clientJwksUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Accept Valid Asymmetric ID Token Signature es256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        List<GrantType> grantTypes = Arrays.asList(GrantType.AUTHORIZATION_CODE);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, null, StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES256);
        registerRequest.setPostLogoutRedirectUris(StringUtils.spaceSeparatedToList((String)postLogoutRedirectUri));
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        registerRequest.setRequireAuthTime(Boolean.valueOf(true));
        registerRequest.setDefaultMaxAge(Integer.valueOf(3600));
        registerRequest.setGrantTypes(grantTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest((BaseRequest)registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AcceptValidAsymmetricIdTokenSignature.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        Assert.assertEquals((String)authorizationResponse.getState(), (String)state);
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        ECDSAPublicKey publicKey = JwkClient.getECDSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        ECDSASigner ecdsaSigner = new ECDSASigner(SignatureAlgorithm.ES256, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner.validate(jwt));
    }
}

