/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.xdi.oxauth.client.JSONObjectAsserter;
import org.xdi.oxauth.model.register.RegisterResponseParam;

public class ResponseAsserter {
    private final int status;
    private final String entity;
    private JSONObjectAsserter json;

    public ResponseAsserter(int status, String entity) {
        this.status = status;
        this.entity = entity;
    }

    public static ResponseAsserter of(Response response) {
        return new ResponseAsserter(response.getStatus(), (String)response.getEntity());
    }

    public ResponseAsserter assertStatus(int expectedStatusCode) {
        Assert.assertEquals((int)this.status, (int)expectedStatusCode, (String)("Unexpected status code: " + this.status));
        return this;
    }

    public ResponseAsserter assertStatusOk() {
        this.assertStatus(200);
        return this;
    }

    public JSONObjectAsserter assertJsonObject() {
        try {
            return JSONObjectAsserter.of(new JSONObject(this.entity));
        }
        catch (JSONException e) {
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + this.entity), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ResponseAsserter assertRegisterResponse() {
        this.assertStatusOk();
        this.json = this.assertJsonObject();
        this.json.hasKeys(RegisterResponseParam.CLIENT_ID.toString(), RegisterResponseParam.CLIENT_SECRET.toString(), RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString(), RegisterResponseParam.REGISTRATION_CLIENT_URI.toString(), RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString(), RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString());
        return this;
    }

    public JSONObjectAsserter getJson() {
        return this.json;
    }

    public int getStatus() {
        return this.status;
    }

    public String getEntity() {
        return this.entity;
    }
}

