/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util.security;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

public final class PropertiesDecrypter {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesDecrypter.class);
    public static final String BIND_PASSWORD = "bindPassword";
    public static final String TRUST_STORE_PIN = "ssl.trustStorePin";

    private PropertiesDecrypter() {
    }

    public static Properties decryptProperties(Properties properties, String encryptionKey) {
        try {
            return PropertiesDecrypter.decryptProperties(StringEncrypter.defaultInstance(), properties, encryptionKey);
        }
        catch (StringEncrypter.EncryptionException ex) {
            LOG.error(String.format("Failed to decript '%s' property", BIND_PASSWORD), ex);
            return properties;
        }
    }

    public static Properties decryptProperties(StringEncrypter stringEncrypter, Properties properties) {
        return PropertiesDecrypter.decryptProperties(stringEncrypter, properties, null);
    }

    public static Properties decryptProperties(StringEncrypter stringEncrypter, Properties properties, String encryptionKey) {
        if (properties == null) {
            return properties;
        }
        Properties clondedProperties = (Properties)properties.clone();
        PropertiesDecrypter.decriptProperty(stringEncrypter, clondedProperties, encryptionKey, BIND_PASSWORD, true);
        PropertiesDecrypter.decriptProperty(stringEncrypter, clondedProperties, encryptionKey, TRUST_STORE_PIN, true);
        return clondedProperties;
    }

    public static Properties decryptAllProperties(StringEncrypter stringEncrypter, Properties properties) {
        return PropertiesDecrypter.decryptAllProperties(stringEncrypter, properties, null);
    }

    public static Properties decryptAllProperties(StringEncrypter stringEncrypter, Properties properties, String encryptionKey) {
        if (properties == null) {
            return properties;
        }
        Properties clondedProperties = (Properties)properties.clone();
        for (Object key : clondedProperties.keySet()) {
            PropertiesDecrypter.decriptProperty(stringEncrypter, clondedProperties, encryptionKey, (String)key, true);
        }
        return clondedProperties;
    }

    private static void decriptProperty(StringEncrypter stringEncrypter, Properties properties, String encryptionKey, String propertyName, boolean silent) {
        String encryptedPassword = properties.getProperty(propertyName);
        if (StringHelper.isEmpty(encryptedPassword)) {
            return;
        }
        try {
            String decryptedProperty = StringHelper.isEmpty(encryptionKey) ? stringEncrypter.decrypt(properties.getProperty(propertyName), silent) : stringEncrypter.decrypt(properties.getProperty(propertyName), encryptionKey, silent);
            properties.put(propertyName, decryptedProperty);
        }
        catch (StringEncrypter.EncryptionException ex) {
            LOG.error(String.format("Failed to decript '%s' property", propertyName), ex);
        }
    }

    public static String decryptProperty(String encryptedValue, boolean returnSource, String encryptionKey) {
        String resultValue;
        block3: {
            if (encryptedValue == null) {
                return encryptedValue;
            }
            resultValue = returnSource ? encryptedValue : null;
            try {
                resultValue = StringEncrypter.defaultInstance().decrypt(encryptedValue, encryptionKey);
            }
            catch (Exception ex) {
                if (returnSource) break block3;
                LOG.error(String.format("Failed to decrypt value: '%s'", encryptedValue, ex));
            }
        }
        return resultValue;
    }
}

