/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public final class Util {
    public static final String UTF8 = "UTF-8";

    private Util() {
    }

    public static <T> ArrayList<T> array2ArrayList(T[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        List<T> list = Arrays.asList(array);
        return new ArrayList<T>(list);
    }

    public static List<String> makeStringList(List<?> list) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (Object o : list) {
            returnList.add(o.toString().trim());
        }
        return returnList;
    }

    public static List<String> makeStringList(String item) {
        ArrayList<String> returnList = new ArrayList<String>(1);
        returnList.add(item.trim());
        return returnList;
    }

    public static List<String> makeStringList(String[] array) {
        return Util.array2ArrayList(array);
    }

    public static <E> List<E> getDistinct(List<E> list) {
        LinkedHashSet<E> set = new LinkedHashSet<E>(list);
        return new ArrayList<E>(set);
    }

    public static String asJson(Object object) throws IOException {
        ObjectMapper mapper = Util.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(object);
    }

    public static String asPrettyJson(Object object) throws IOException {
        ObjectMapper mapper = Util.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        ObjectWriter writer = mapper.writer().withDefaultPrettyPrinter();
        return writer.writeValueAsString(object);
    }

    public static ObjectMapper createJsonMapper() {
        JaxbAnnotationIntrospector jaxb = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        AnnotationIntrospector.Pair pair = new AnnotationIntrospector.Pair(jackson, jaxb);
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().withAnnotationIntrospector(pair);
        mapper.getSerializationConfig().withAnnotationIntrospector(pair);
        return mapper;
    }

    public static String getFirstRDN(String dn) {
        if (dn == null) {
            return null;
        }
        String rdn = dn.split(",")[0];
        return rdn;
    }

    public static String getFirstRDNValue(String dn) {
        if (dn == null) {
            return null;
        }
        String rdn = dn.split(",")[0];
        return rdn.split("=")[1];
    }

    public static String getSecondRDN(String dn) {
        if (dn == null) {
            return null;
        }
        String rdn = dn.split(",")[1];
        return rdn;
    }

    public static String getSecondRDNValue(String dn) {
        if (dn == null) {
            return null;
        }
        String rdn = dn.split(",")[1];
        return rdn.split("=")[1];
    }

    public static boolean equals(String str1, String str2) {
        return !(str1 == null ? str2 != null : !str1.equalsIgnoreCase(str2));
    }

    public static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String encodeString(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            return new URI(null, str, null).toString();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static String getEmtpyStringIfNull(String str) {
        return str == null ? "" : str;
    }

    public static <T> void removeDuplicateWithOrder(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        ArrayList<T> newList = new ArrayList<T>();
        for (T item : list) {
            if (!set.add(item)) continue;
            newList.add(item);
        }
        list.clear();
        list.addAll(newList);
    }
}

