/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public boolean writeToFile(String filePath, long position, String data) {
        try {
            File f = new File(filePath);
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            raf.seek(position);
            StringBuilder dataAfterPostion = new StringBuilder(data);
            while (raf.getFilePointer() < raf.length()) {
                String line = raf.readLine();
                dataAfterPostion.append(line);
            }
            raf.seek(position);
            raf.writeUTF(dataAfterPostion.toString());
            raf.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeLargeFile(String filePath, long position, String data) {
        try {
            FileWriter fstream = new FileWriter(filePath);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(data);
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long findFirstPosition(String filePath, String searchStr) {
        try {
            File f = new File(filePath);
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            long position = -1L;
            while (raf.getFilePointer() < raf.length()) {
                String line = raf.readLine();
                if (!line.contains(searchStr)) continue;
                position = raf.getFilePointer() + (long)line.indexOf(searchStr) - (long)(line.length() + 1);
                break;
            }
            return position;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public long findLastPosition(String filePath, String searchStr) {
        try {
            File f = new File(filePath);
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            long position = -1L;
            while (raf.getFilePointer() < raf.length()) {
                String line = raf.readLine();
                if (!line.contains(searchStr)) continue;
                position = raf.getFilePointer() + (long)line.indexOf(searchStr) - (long)line.length();
            }
            return position;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFromURL(String url) {
        try {
            URL u = new URL(url);
            StringBuilder data = new StringBuilder();
            InputStream is = u.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String theLine;
                while ((theLine = br.readLine()) != null) {
                    data.append(theLine);
                }
            }
            finally {
                IOUtils.closeQuietly(br);
            }
            return data.toString();
        }
        catch (MalformedURLException ex) {
            LOG.error(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(String filePath) {
        try {
            StringBuilder data = new StringBuilder();
            FileInputStream fstream = new FileInputStream(filePath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                String strLine = "";
                while ((strLine = br.readLine()) != null) {
                    data.append(strLine);
                }
            }
            finally {
                IOUtils.closeQuietly(br);
            }
            return data.toString();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readFile(String filePath) {
        StringBuffer buf = new StringBuffer();
        FileInputStream input = null;
        try {
            int i;
            input = new FileInputStream(new File(filePath));
            byte[] buffer = new byte[10];
            while ((i = input.read(buffer)) >= 0) {
                byte[] outBuffer = new byte[i];
                System.arraycopy(buffer, 0, outBuffer, 0, i);
                buf.append(new String(outBuffer, "UTF-8"));
            }
        }
        catch (Exception ex) {
            try {
                LOG.debug("File read error: ", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly(input);
        }
        IOUtils.closeQuietly(input);
        return buf;
    }
}

