/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.io.File;
import java.security.PrivateKey;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.bouncycastle.util.encoders.Base64;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithmFamily;
import org.xdi.oxauth.model.util.SecurityProviderUtility;

public class KeyExporter {
    private static final String KEY_STORE_FILE = "keystore";
    private static final String KEY_STORE_PASSWORD = "keypasswd";
    private static final String KEY_ALIAS = "alias";
    private static final String EXPORT_FILE = "exportfile";
    private static final String HELP = "h";
    private static final Logger log;

    public static void main(String[] args) throws Exception {
        new Cli(args).parse();
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        log = Logger.getLogger(KeyExporter.class);
    }

    public static class Cli {
        private String[] args = null;
        private Options options = new Options();

        public Cli(String[] args) {
            this.args = args;
            this.options.addOption(KeyExporter.KEY_STORE_FILE, true, "Key Store file.");
            this.options.addOption(KeyExporter.KEY_STORE_PASSWORD, true, "Key Store password.");
            this.options.addOption(KeyExporter.KEY_ALIAS, true, "Key alias.");
            this.options.addOption(KeyExporter.EXPORT_FILE, true, "Export file.");
            this.options.addOption(KeyExporter.HELP, false, "Show help.");
        }

        public void parse() {
            BasicParser parser = new BasicParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(this.options, this.args);
                if (cmd.hasOption(KeyExporter.HELP)) {
                    this.help();
                }
                if (cmd.hasOption(KeyExporter.KEY_STORE_FILE) && cmd.hasOption(KeyExporter.KEY_STORE_PASSWORD) && cmd.hasOption(KeyExporter.KEY_ALIAS) && cmd.hasOption(KeyExporter.EXPORT_FILE)) {
                    String keyStore = cmd.getOptionValue(KeyExporter.KEY_STORE_FILE);
                    String keyStorePasswd = cmd.getOptionValue(KeyExporter.KEY_STORE_PASSWORD);
                    String keyAlias = cmd.getOptionValue(KeyExporter.KEY_ALIAS);
                    String exportFile = cmd.getOptionValue(KeyExporter.EXPORT_FILE);
                    try {
                        SecurityProviderUtility.installBCProvider(true);
                        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStore, keyStorePasswd, "CN=oxAuth CA Certificates");
                        PrivateKey privateKey = cryptoProvider.getPrivateKey(keyAlias);
                        String base64EncodedKey = WordUtils.wrap(new String(Base64.encode(privateKey.getEncoded())), 64, "\n", true);
                        StringBuilder sb = new StringBuilder();
                        SignatureAlgorithm signatureAlgorithm = cryptoProvider.getSignatureAlgorithm(keyAlias);
                        if (SignatureAlgorithmFamily.RSA.equals((Object)signatureAlgorithm.getFamily())) {
                            sb.append("-----BEGIN RSA PRIVATE KEY-----\n");
                            sb.append(base64EncodedKey);
                            sb.append("\n");
                            sb.append("-----END RSA PRIVATE KEY-----\n");
                        } else {
                            sb.append("-----BEGIN PRIVATE KEY-----\n");
                            sb.append(base64EncodedKey);
                            sb.append("\n");
                            sb.append("-----END PRIVATE KEY-----\n");
                        }
                        FileUtils.writeStringToFile(new File(exportFile), sb.toString());
                    }
                    catch (Exception e) {
                        log.error("Failed to export key", e);
                        this.help();
                    }
                } else {
                    this.help();
                }
            }
            catch (ParseException e) {
                log.error("Failed to export key", e);
                this.help();
            }
        }

        private void help() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("KeyExporter -keystore path -keypasswd secret -alias 2d4817e7-5fe8-4b6b-8f64-fe3723625122 -exportfile=export-path", this.options);
            System.exit(0);
        }
    }
}

