/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class Base64Util {
    private static final Logger log = Logger.getLogger(Base64Util.class);

    public static String base64urlencode(byte[] arg) {
        String s = Base64.encodeBase64String(arg);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] base64urldecode(String arg) throws IllegalArgumentException {
        String s = Base64Util.removePadding(arg);
        return Base64.decodeBase64(s);
    }

    public static String base64urldecodeToString(String arg) throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] decoded = Base64Util.base64urldecode(arg);
        return new String(decoded, "UTF-8");
    }

    public static String removePadding(String base64UrlEncoded) {
        String s = base64UrlEncoded;
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal base64url string.");
            }
        }
        return s;
    }

    public static String base64urlencodeUnsignedBigInt(BigInteger bigInteger) {
        byte[] array = bigInteger.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return Base64Util.base64urlencode(array);
    }

    public static byte[] unsignedToBytes(int[] plaintextUnsignedBytes) {
        byte[] bytes = new byte[plaintextUnsignedBytes.length];
        for (int i = 0; i < plaintextUnsignedBytes.length; ++i) {
            bytes[i] = (byte)plaintextUnsignedBytes[i];
        }
        return bytes;
    }

    public static void main(String[] args) throws IllegalArgumentException, UnsupportedEncodingException {
        String dec = Base64Util.base64urldecodeToString("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");
        System.out.println(dec);
    }
}

