/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma.persistence;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;

@LdapEntry
@LdapObjectClass(values={"top", "oxUmaResourcePermission"})
public class UmaPermission {
    public static final String PCT = "pct";
    @LdapDN
    private String dn;
    @LdapAttribute(name="oxStatus")
    private String status;
    @LdapAttribute(name="oxTicket")
    private String ticket;
    @LdapAttribute(name="oxConfigurationCode")
    private String configurationCode;
    @LdapAttribute(name="oxAuthExpiration")
    private Date expirationDate;
    @LdapAttribute(name="oxResourceSetId")
    private String resourceId;
    @LdapAttribute(name="oxAuthUmaScope")
    private List<String> scopeDns;
    @LdapJsonObject
    @LdapAttribute(name="oxAttributes")
    private Map<String, String> attributes;
    private boolean expired;

    public UmaPermission() {
    }

    public UmaPermission(String resourceId, List<String> scopes, String ticket, String configurationCode, Date expirationDate) {
        this.resourceId = resourceId;
        this.scopeDns = scopes;
        this.ticket = ticket;
        this.configurationCode = configurationCode;
        this.expirationDate = expirationDate;
        this.checkExpired();
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public void checkExpired() {
        this.checkExpired(new Date());
    }

    public void checkExpired(Date now) {
        if (now.after(this.expirationDate)) {
            this.expired = true;
        }
    }

    public boolean isValid() {
        return !this.expired;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getConfigurationCode() {
        return this.configurationCode;
    }

    public void setConfigurationCode(String configurationCode) {
        this.configurationCode = configurationCode;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public List<String> getScopeDns() {
        if (this.scopeDns == null) {
            this.scopeDns = new ArrayList<String>();
        }
        return this.scopeDns;
    }

    public void setScopeDns(List<String> p_scopeDns) {
        this.scopeDns = p_scopeDns;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes != null ? attributes : new HashMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UmaPermission that = (UmaPermission)o;
        return !(this.ticket == null ? that.ticket != null : !this.ticket.equals(that.ticket));
    }

    public int hashCode() {
        return this.ticket != null ? this.ticket.hashCode() : 0;
    }

    public String toString() {
        return "UmaPermission{dn='" + this.dn + '\'' + ", status='" + this.status + '\'' + ", ticket='" + this.ticket + '\'' + ", configurationCode='" + this.configurationCode + '\'' + ", expirationDate=" + this.expirationDate + ", resourceId='" + this.resourceId + '\'' + ", scopeDns=" + this.scopeDns + ", expired=" + this.expired + '}';
    }
}

