/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwt;

import java.net.URI;
import java.util.Date;
import java.util.UUID;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.JwtClaimSet;
import org.xdi.oxauth.model.jwt.JwtType;

public class JwtClaims
extends JwtClaimSet {
    public JwtClaims() {
    }

    public JwtClaims(JSONObject jsonObject) {
        super(jsonObject);
    }

    public JwtClaims(String base64JsonObject) throws InvalidJwtException {
        super(base64JsonObject);
    }

    public void setExpirationTime(Date expirationTime) {
        this.setClaim("exp", expirationTime);
    }

    public void setNotBefore(Date notBefore) {
        this.setClaim("nbf", notBefore);
    }

    public void setIssuedAt(Date issuedAt) {
        this.setClaim("iat", issuedAt);
    }

    public void setIssuer(String issuer) {
        this.setClaim("iss", issuer);
    }

    public void setIssuer(URI issuer) {
        if (issuer == null) {
            this.setNullClaim("iss");
        } else {
            this.setClaim("iss", issuer.toString());
        }
    }

    public void setAudience(String audience) {
        this.setClaim("aud", audience);
    }

    public void setAudience(URI audience) {
        if (audience == null) {
            this.setNullClaim("aud");
        } else {
            this.setClaim("aud", audience.toString());
        }
    }

    public void setSubjectIdentifier(String subjectIdentifier) {
        this.setClaim("sub", subjectIdentifier);
    }

    public void setSubjectIdentifier(URI subjectIdentifier) {
        if (subjectIdentifier == null) {
            this.setNullClaim("sub");
        } else {
            this.setClaim("sub", subjectIdentifier.toString());
        }
    }

    public void setJwtId(String jwtId) {
        this.setClaim("jti", jwtId);
    }

    public void setJwtId(UUID jwtId) {
        if (jwtId == null) {
            this.setNullClaim("jti");
        } else {
            this.setClaim("jti", jwtId.toString());
        }
    }

    public void setType(JwtType type) {
        if (type == null) {
            this.setNullClaim("typ");
        } else {
            this.setClaim("typ", type.toString());
        }
    }
}

