/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwt;

import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.JwtClaims;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.token.JsonWebResponse;

public class Jwt
extends JsonWebResponse {
    private String encodedHeader = null;
    private String encodedClaims = null;
    private String encodedSignature = null;
    private boolean loaded = false;

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public void setEncodedSignature(String encodedSignature) {
        this.encodedSignature = encodedSignature;
    }

    public String getSigningInput() throws InvalidJwtException {
        if (this.loaded) {
            return this.encodedHeader + "." + this.encodedClaims;
        }
        return this.header.toBase64JsonObject() + "." + this.claims.toBase64JsonObject();
    }

    public static Jwt parse(String encodedJwt) throws InvalidJwtException {
        if (StringUtils.isBlank(encodedJwt)) {
            return null;
        }
        String encodedHeader = null;
        String encodedClaims = null;
        String encodedSignature = null;
        String[] jwtParts = encodedJwt.split("\\.");
        if (jwtParts.length == 2) {
            encodedHeader = jwtParts[0];
            encodedClaims = jwtParts[1];
            encodedSignature = "";
        } else if (jwtParts.length == 3) {
            encodedHeader = jwtParts[0];
            encodedClaims = jwtParts[1];
            encodedSignature = jwtParts[2];
        } else {
            throw new InvalidJwtException("Invalid JWT format.");
        }
        Jwt jwt = new Jwt();
        jwt.setHeader(new JwtHeader(encodedHeader));
        jwt.setClaims(new JwtClaims(encodedClaims));
        jwt.setEncodedSignature(encodedSignature);
        jwt.encodedHeader = encodedHeader;
        jwt.encodedClaims = encodedClaims;
        jwt.loaded = true;
        return jwt;
    }

    @Override
    public String toString() {
        try {
            if (this.encodedSignature == null) {
                return this.getSigningInput() + ".";
            }
            return this.getSigningInput() + "." + this.encodedSignature;
        }
        catch (InvalidJwtException e) {
            e.printStackTrace();
            return "";
        }
    }
}

