/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwe;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.exception.InvalidParameterException;
import org.xdi.oxauth.model.util.Base64Util;

public class KeyDerivationFunction {
    public static byte[] generateCek(byte[] cmk, BlockEncryptionAlgorithm blockEncryptionAlgorithm) throws UnsupportedEncodingException, NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterException {
        if (cmk == null) {
            throw new InvalidParameterException("The content master key (CMK) is null");
        }
        if (blockEncryptionAlgorithm == null) {
            throw new InvalidParameterException("The block encryption algorithm is null");
        }
        if (blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 && blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A256CBC_PLUS_HS512) {
            throw new InvalidParameterException("The block encryption algorithm is not supported");
        }
        byte[] round1 = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 1});
        byte[] outputBitSize = null;
        outputBitSize = blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 ? Base64Util.unsignedToBytes(new int[]{0, 0, 0, 128}) : Base64Util.unsignedToBytes(new int[]{0, 0, 1, 0});
        byte[] encValue = blockEncryptionAlgorithm.getName().getBytes("UTF-8");
        byte[] epu = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] epv = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] label = "Encryption".getBytes("UTF-8");
        byte[] round1Input = ArrayUtils.addAll(round1, cmk);
        round1Input = ArrayUtils.addAll(round1Input, outputBitSize);
        round1Input = ArrayUtils.addAll(round1Input, encValue);
        round1Input = ArrayUtils.addAll(round1Input, epu);
        round1Input = ArrayUtils.addAll(round1Input, epv);
        round1Input = ArrayUtils.addAll(round1Input, label);
        MessageDigest mda = MessageDigest.getInstance(blockEncryptionAlgorithm.getMessageDiggestAlgorithm(), "BC");
        byte[] round1Hash = mda.digest(round1Input);
        byte[] cek = Arrays.copyOf(round1Hash, blockEncryptionAlgorithm.getCekLength() / 8);
        return cek;
    }

    public static byte[] generateCik(byte[] cmk, BlockEncryptionAlgorithm blockEncryptionAlgorithm) throws UnsupportedEncodingException, NoSuchProviderException, NoSuchAlgorithmException, InvalidParameterException {
        if (cmk == null) {
            throw new InvalidParameterException("The content master key (CMK) is null");
        }
        if (blockEncryptionAlgorithm == null) {
            throw new InvalidParameterException("The block encryption algorithm is null");
        }
        if (blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 && blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A256CBC_PLUS_HS512) {
            throw new InvalidParameterException("The block encryption algorithm is not supported");
        }
        byte[] round1 = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 1});
        byte[] outputBitSize = null;
        outputBitSize = blockEncryptionAlgorithm != BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 ? Base64Util.unsignedToBytes(new int[]{0, 0, 1, 0}) : Base64Util.unsignedToBytes(new int[]{0, 0, 2, 0});
        byte[] encValue = blockEncryptionAlgorithm.getName().getBytes("UTF-8");
        byte[] epu = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] epv = Base64Util.unsignedToBytes(new int[]{0, 0, 0, 0});
        byte[] label = "Integrity".getBytes("UTF-8");
        byte[] round1Input = ArrayUtils.addAll(round1, cmk);
        round1Input = ArrayUtils.addAll(round1Input, outputBitSize);
        round1Input = ArrayUtils.addAll(round1Input, encValue);
        round1Input = ArrayUtils.addAll(round1Input, epu);
        round1Input = ArrayUtils.addAll(round1Input, epv);
        round1Input = ArrayUtils.addAll(round1Input, label);
        MessageDigest mda = MessageDigest.getInstance(blockEncryptionAlgorithm.getMessageDiggestAlgorithm(), "BC");
        byte[] cik = mda.digest(round1Input);
        return cik;
    }
}

