/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwe;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidParameterException;
import org.xdi.oxauth.model.jwe.AbstractJweDecrypter;
import org.xdi.oxauth.model.jwe.KeyDerivationFunction;
import org.xdi.oxauth.model.util.Base64Util;

public class JweDecrypterImpl
extends AbstractJweDecrypter {
    private PrivateKey privateKey;
    private org.xdi.oxauth.model.crypto.signature.RSAPrivateKey rsaPrivateKey;
    private byte[] sharedSymmetricKey;

    public JweDecrypterImpl(byte[] sharedSymmetricKey) {
        if (sharedSymmetricKey != null) {
            this.sharedSymmetricKey = (byte[])sharedSymmetricKey.clone();
        }
    }

    public JweDecrypterImpl(org.xdi.oxauth.model.crypto.signature.RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public JweDecrypterImpl(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public byte[] decryptEncryptionKey(String encodedEncryptedKey) throws InvalidJweException {
        if (this.getKeyEncryptionAlgorithm() == null) {
            throw new InvalidJweException("The key encryption algorithm is null");
        }
        if (encodedEncryptedKey == null) {
            throw new InvalidJweException("The encoded encryption key is null");
        }
        try {
            if (this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.RSA_OAEP || this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.RSA1_5) {
                if (this.rsaPrivateKey == null && this.privateKey == null) {
                    throw new InvalidJweException("The RSA private key is null");
                }
                Cipher cipher = Cipher.getInstance(this.getKeyEncryptionAlgorithm().getAlgorithm());
                if (this.rsaPrivateKey != null) {
                    KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyEncryptionAlgorithm().getFamily(), "BC");
                    RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(this.rsaPrivateKey.getModulus(), this.rsaPrivateKey.getPrivateExponent());
                    RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(privKeySpec);
                    cipher.init(2, privKey);
                } else {
                    cipher.init(2, this.privateKey);
                }
                byte[] decryptedKey = cipher.doFinal(Base64Util.base64urldecode(encodedEncryptedKey));
                return decryptedKey;
            }
            if (this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.A128KW || this.getKeyEncryptionAlgorithm() == KeyEncryptionAlgorithm.A256KW) {
                if (this.sharedSymmetricKey == null) {
                    throw new InvalidJweException("The shared symmetric key is null");
                }
                if (this.sharedSymmetricKey.length != 16) {
                    MessageDigest sha = MessageDigest.getInstance("SHA-256");
                    this.sharedSymmetricKey = sha.digest(this.sharedSymmetricKey);
                    this.sharedSymmetricKey = Arrays.copyOf(this.sharedSymmetricKey, 16);
                }
                byte[] encryptedKey = Base64Util.base64urldecode(encodedEncryptedKey);
                SecretKeySpec keyEncryptionKey = new SecretKeySpec(this.sharedSymmetricKey, "AES");
                AESWrapEngine aesWrapEngine = new AESWrapEngine();
                KeyParameter params = new KeyParameter(keyEncryptionKey.getEncoded());
                aesWrapEngine.init(false, params);
                byte[] decryptedKey = aesWrapEngine.unwrap(encryptedKey, 0, encryptedKey.length);
                return decryptedKey;
            }
            throw new InvalidJweException("The key encryption algorithm is not supported");
        }
        catch (NoSuchPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidJweException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidJweException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidCipherTextException e) {
            throw new InvalidJweException(e);
        }
    }

    @Override
    public String decryptCipherText(String encodedCipherText, byte[] contentMasterKey, byte[] initializationVector, byte[] authenticationTag, byte[] additionalAuthenticatedData) throws InvalidJweException {
        if (this.getBlockEncryptionAlgorithm() == null) {
            throw new InvalidJweException("The block encryption algorithm is null");
        }
        if (contentMasterKey == null) {
            throw new InvalidJweException("The content master key (CMK) is null");
        }
        if (initializationVector == null) {
            throw new InvalidJweException("The initialization vector is null");
        }
        if (authenticationTag == null) {
            throw new InvalidJweException("The authentication tag is null");
        }
        if (additionalAuthenticatedData == null) {
            throw new InvalidJweException("The additional authentication data is null");
        }
        try {
            if (this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A128GCM || this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A256GCM) {
                int MAC_SIZE_BITS = 128;
                byte[] cipherText = Base64Util.base64urldecode(encodedCipherText);
                KeyParameter key = new KeyParameter(contentMasterKey);
                AEADParameters aeadParameters = new AEADParameters(key, 128, initializationVector, additionalAuthenticatedData);
                SecretKeySpec sks = new SecretKeySpec(contentMasterKey, "AES");
                AESEngine blockCipher = new AESEngine();
                KeyParameter params = new KeyParameter(sks.getEncoded());
                blockCipher.init(false, params);
                GCMBlockCipher aGCMBlockCipher = new GCMBlockCipher(blockCipher);
                aGCMBlockCipher.init(false, aeadParameters);
                byte[] input = new byte[cipherText.length + authenticationTag.length];
                System.arraycopy(cipherText, 0, input, 0, cipherText.length);
                System.arraycopy(authenticationTag, 0, input, cipherText.length, authenticationTag.length);
                int len = aGCMBlockCipher.getOutputSize(input.length);
                byte[] out = new byte[len];
                int outOff = aGCMBlockCipher.processBytes(input, 0, input.length, out, 0);
                aGCMBlockCipher.doFinal(out, outOff);
                String plaintext = new String(out, Charset.forName("UTF-8"));
                return plaintext;
            }
            if (this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A128CBC_PLUS_HS256 || this.getBlockEncryptionAlgorithm() == BlockEncryptionAlgorithm.A256CBC_PLUS_HS512) {
                byte[] cipherText = Base64Util.base64urldecode(encodedCipherText);
                byte[] cek = KeyDerivationFunction.generateCek(contentMasterKey, this.getBlockEncryptionAlgorithm());
                Cipher cipher = Cipher.getInstance(this.getBlockEncryptionAlgorithm().getAlgorithm());
                IvParameterSpec ivParameter = new IvParameterSpec(initializationVector);
                cipher.init(2, (Key)new SecretKeySpec(cek, "AES"), ivParameter);
                byte[] decodedPlainTextBytes = cipher.doFinal(cipherText);
                String decodedPlainText = new String(decodedPlainTextBytes, Charset.forName("UTF-8"));
                String securedInputValue = new String(additionalAuthenticatedData, Charset.forName("UTF-8")) + "." + encodedCipherText;
                byte[] cik = KeyDerivationFunction.generateCik(contentMasterKey, this.getBlockEncryptionAlgorithm());
                SecretKeySpec secretKey = new SecretKeySpec(cik, this.getBlockEncryptionAlgorithm().getIntegrityValueAlgorithm());
                Mac mac = Mac.getInstance(this.getBlockEncryptionAlgorithm().getIntegrityValueAlgorithm());
                mac.init(secretKey);
                byte[] integrityValue = mac.doFinal(securedInputValue.getBytes("UTF-8"));
                if (!Arrays.equals(integrityValue, authenticationTag)) {
                    throw new InvalidJweException("The authentication tag is not valid");
                }
                return decodedPlainText;
            }
            throw new InvalidJweException("The block encryption algorithm is not supported");
        }
        catch (InvalidCipherTextException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidJweException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidJweException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException(e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidJweException(e);
        }
        catch (InvalidParameterException e) {
            throw new InvalidJweException(e);
        }
    }
}

