/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.jwe;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwe.JweDecrypter;
import org.xdi.oxauth.model.jwt.JwtClaims;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.util.Base64Util;

public abstract class AbstractJweDecrypter
implements JweDecrypter {
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    private BlockEncryptionAlgorithm blockEncryptionAlgorithm;

    @Override
    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    @Override
    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    @Override
    public BlockEncryptionAlgorithm getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    @Override
    public void setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm blockEncryptionAlgorithm) {
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    @Override
    public Jwe decrypt(String encryptedJwe) throws InvalidJweException {
        try {
            if (StringUtils.isBlank(encryptedJwe)) {
                return null;
            }
            String[] jweParts = encryptedJwe.split("\\.");
            if (jweParts.length != 5) {
                throw new InvalidJwtException("Invalid JWS format.");
            }
            String encodedHeader = jweParts[0];
            String encodedEncryptedKey = jweParts[1];
            String encodedInitializationVector = jweParts[2];
            String encodedCipherText = jweParts[3];
            String encodedIntegrityValue = jweParts[4];
            Jwe jwe = new Jwe();
            jwe.setEncodedHeader(encodedHeader);
            jwe.setEncodedEncryptedKey(encodedEncryptedKey);
            jwe.setEncodedInitializationVector(encodedInitializationVector);
            jwe.setEncodedCiphertext(encodedCipherText);
            jwe.setEncodedIntegrityValue(encodedIntegrityValue);
            jwe.setHeader(new JwtHeader(encodedHeader));
            this.keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName(jwe.getHeader().getClaimAsString("alg"));
            this.blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName(jwe.getHeader().getClaimAsString("enc"));
            byte[] contentMasterKey = this.decryptEncryptionKey(encodedEncryptedKey);
            byte[] initializationVector = Base64Util.base64urldecode(encodedInitializationVector);
            byte[] authenticationTag = Base64Util.base64urldecode(encodedIntegrityValue);
            byte[] additionalAuthenticatedData = jwe.getAdditionalAuthenticatedData().getBytes("UTF-8");
            String plainText = this.decryptCipherText(encodedCipherText, contentMasterKey, initializationVector, authenticationTag, additionalAuthenticatedData);
            jwe.setClaims(new JwtClaims(plainText));
            return jwe;
        }
        catch (InvalidJwtException e) {
            throw new InvalidJweException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException(e);
        }
    }

    public abstract byte[] decryptEncryptionKey(String var1) throws InvalidJweException;

    public abstract String decryptCipherText(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws InvalidJweException;
}

