/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto.signature;

import java.math.BigInteger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.PrivateKey;
import org.xdi.oxauth.model.util.Base64Util;

public class ECDSAPrivateKey
extends PrivateKey {
    private BigInteger d;

    public ECDSAPrivateKey(BigInteger d) {
        this.d = d;
    }

    public ECDSAPrivateKey(String d) {
        this.d = new BigInteger(1, Base64Util.base64urldecode(d));
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setD(BigInteger d) {
        this.d = d;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", JSONObject.NULL);
        jsonObject.put("e", JSONObject.NULL);
        jsonObject.put("d", Base64Util.base64urlencodeUnsignedBigInt(this.d));
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (JSONException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

