/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.crypto;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.oxeleven.model.JwksRequestParam;
import org.gluu.oxeleven.model.KeyRequestParam;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.CryptoProviderFactory;
import org.xdi.oxauth.model.crypto.signature.ECEllipticCurve;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithmFamily;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jwk.Use;
import org.xdi.oxauth.model.util.Base64Util;
import sun.security.rsa.RSAPublicKeyImpl;

public abstract class AbstractCryptoProvider {
    public abstract JSONObject generateKey(SignatureAlgorithm var1, Long var2) throws Exception;

    public abstract String sign(String var1, String var2, String var3, SignatureAlgorithm var4) throws Exception;

    public abstract boolean verifySignature(String var1, String var2, String var3, JSONObject var4, String var5, SignatureAlgorithm var6) throws Exception;

    public abstract boolean deleteKey(String var1) throws Exception;

    public String getKeyId(JSONWebKeySet jsonWebKeySet, SignatureAlgorithm signatureAlgorithm, Use use) throws Exception {
        for (JSONWebKey key : jsonWebKeySet.getKeys()) {
            if (signatureAlgorithm != key.getAlg() || use != null && use != key.getUse()) continue;
            return key.getKid();
        }
        return null;
    }

    public JwksRequestParam getJwksRequestParam(JSONObject jwkJsonObject) throws JSONException {
        JwksRequestParam jwks = new JwksRequestParam();
        jwks.setKeyRequestParams(new ArrayList<KeyRequestParam>());
        KeyRequestParam key = new KeyRequestParam();
        key.setAlg(jwkJsonObject.getString("alg"));
        key.setKid(jwkJsonObject.getString("kid"));
        key.setUse(jwkJsonObject.getString("use"));
        key.setKty(jwkJsonObject.getString("kty"));
        key.setN(jwkJsonObject.optString("n"));
        key.setE(jwkJsonObject.optString("e"));
        key.setCrv(jwkJsonObject.optString("crv"));
        key.setX(jwkJsonObject.optString("x"));
        key.setY(jwkJsonObject.optString("y"));
        jwks.getKeyRequestParams().add(key);
        return jwks;
    }

    public static JSONObject generateJwks(int keyRegenerationInterval, int idTokenLifeTime, AppConfiguration configuration) throws Exception {
        JSONArray keys = new JSONArray();
        GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        expirationTime.add(10, keyRegenerationInterval);
        expirationTime.add(13, idTokenLifeTime);
        AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider(configuration);
        try {
            keys.put(cryptoProvider.generateKey(SignatureAlgorithm.RS256, expirationTime.getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keys.put(cryptoProvider.generateKey(SignatureAlgorithm.RS384, expirationTime.getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keys.put(cryptoProvider.generateKey(SignatureAlgorithm.RS512, expirationTime.getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keys.put(cryptoProvider.generateKey(SignatureAlgorithm.ES256, expirationTime.getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keys.put(cryptoProvider.generateKey(SignatureAlgorithm.ES384, expirationTime.getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keys.put(cryptoProvider.generateKey(SignatureAlgorithm.ES512, expirationTime.getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("keys", keys);
        return jsonObject;
    }

    public PublicKey getPublicKey(String alias, JSONObject jwks) throws Exception {
        PublicKey publicKey = null;
        JSONArray webKeys = jwks.getJSONArray("keys");
        for (int i = 0; i < webKeys.length(); ++i) {
            JSONObject key = webKeys.getJSONObject(i);
            if (!alias.equals(key.getString("kid"))) continue;
            SignatureAlgorithmFamily family = null;
            if (key.has("alg")) {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString(key.optString("alg"));
                family = signatureAlgorithm.getFamily();
            } else if (key.has("kty")) {
                family = SignatureAlgorithmFamily.fromString(key.getString("kty"));
            }
            if (SignatureAlgorithmFamily.RSA.equals((Object)family)) {
                publicKey = new RSAPublicKeyImpl(new BigInteger(1, Base64Util.base64urldecode(key.getString("n"))), new BigInteger(1, Base64Util.base64urldecode(key.getString("e"))));
                continue;
            }
            if (!SignatureAlgorithmFamily.EC.equals((Object)family)) continue;
            ECEllipticCurve curve = ECEllipticCurve.fromString(key.optString("crv"));
            AlgorithmParameters parameters = AlgorithmParameters.getInstance(SignatureAlgorithmFamily.EC.toString());
            parameters.init(new ECGenParameterSpec(curve.getAlias()));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            publicKey = KeyFactory.getInstance(SignatureAlgorithmFamily.EC.toString()).generatePublic(new ECPublicKeySpec(new ECPoint(new BigInteger(1, Base64Util.base64urldecode(key.getString("x"))), new BigInteger(1, Base64Util.base64urldecode(key.getString("y")))), ecParameters));
        }
        return publicKey;
    }
}

