/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.xdi.oxauth.model.common.HasParamName;

public enum ResponseType implements HasParamName,
LdapEnum
{
    CODE("code", "Authorization Code Grant Type"),
    TOKEN("token", "Implicit Grant Type"),
    ID_TOKEN("id_token", "ID Token");

    private final String value;
    private final String displayName;
    private static Map<String, ResponseType> mapByValues;

    private ResponseType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    @JsonCreator
    public static ResponseType fromString(String param) {
        return ResponseType.getByValue(param);
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static List<ResponseType> fromString(String paramList, String separator) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        if (paramList != null && !paramList.isEmpty()) {
            String[] params;
            for (String param : params = paramList.split(separator)) {
                for (ResponseType rt : ResponseType.values()) {
                    if (!param.equals(rt.value) || responseTypes.contains(rt)) continue;
                    responseTypes.add(rt);
                }
            }
        }
        return responseTypes;
    }

    public static boolean isImplicitFlow(String responseTypes) {
        return !responseTypes.contains("code") && (responseTypes.contains("id_token") || responseTypes.contains("token"));
    }

    public static String[] toStringArray(ResponseType[] responseTypes) {
        if (responseTypes == null) {
            return null;
        }
        String[] resultResponseTypes = new String[responseTypes.length];
        for (int i = 0; i < responseTypes.length; ++i) {
            resultResponseTypes[i] = responseTypes[i].getValue();
        }
        return resultResponseTypes;
    }

    public static ResponseType getByValue(String value) {
        return mapByValues.get(value);
    }

    @Override
    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return ResponseType.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, ResponseType>();
        for (ResponseType enumType : ResponseType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

