/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.xdi.oxauth.model.common.HasParamName;

public enum GrantType implements HasParamName,
LdapEnum
{
    AUTHORIZATION_CODE("authorization_code"),
    IMPLICIT("implicit"),
    RESOURCE_OWNER_PASSWORD_CREDENTIALS("password"),
    CLIENT_CREDENTIALS("client_credentials"),
    REFRESH_TOKEN("refresh_token"),
    OXAUTH_UMA_TICKET("urn:ietf:params:oauth:grant-type:uma-ticket");

    private final String value;
    private static Map<String, GrantType> mapByValues;

    private GrantType() {
        this.value = null;
    }

    private GrantType(String value) {
        this.value = value;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static GrantType fromString(String param) {
        if (param != null) {
            for (GrantType gt : GrantType.values()) {
                if (!param.equals(gt.value)) continue;
                return gt;
            }
        }
        return null;
    }

    public static String[] toStringArray(GrantType[] grantTypes) {
        if (grantTypes == null) {
            return null;
        }
        String[] resultGrantTypes = new String[grantTypes.length];
        for (int i = 0; i < grantTypes.length; ++i) {
            resultGrantTypes[i] = grantTypes[i].getValue();
        }
        return resultGrantTypes;
    }

    public static GrantType getByValue(String value) {
        return mapByValues.get(value);
    }

    @Override
    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return GrantType.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, GrantType>();
        for (GrantType enumType : GrantType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

