/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.authorize;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;

public class CodeVerifier {
    private static final int MAX_CODE_VERIFIER_LENGTH = 128;
    private static final int MIN_CODE_VERIFIER_LENGTH = 43;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private String codeVerifier = CodeVerifier.generateCodeVerifier();
    private String codeChallenge;
    private CodeChallengeMethod transformationType;

    public CodeVerifier() {
        this(CodeChallengeMethod.S256);
    }

    public CodeVerifier(CodeChallengeMethod transformationType) {
        this.transformationType = transformationType;
        this.codeChallenge = CodeVerifier.generateCodeChallenge(transformationType, this.codeVerifier);
    }

    public static String generateCodeChallenge(CodeChallengeMethod codeChallengeMethod, String codeVerifier) {
        Preconditions.checkNotNull(codeChallengeMethod);
        Preconditions.checkNotNull(codeVerifier);
        switch (codeChallengeMethod) {
            case PLAIN: {
                return codeVerifier;
            }
            case S256: {
                return CodeVerifier.s256(codeVerifier);
            }
        }
        throw new RuntimeException("Unsupported code challenge method: " + (Object)((Object)codeChallengeMethod));
    }

    public static boolean matched(String codeChallenge, String codeChallengeMethod, String codeVerifier) {
        return CodeVerifier.matched(codeChallenge, CodeChallengeMethod.fromString(codeChallengeMethod), codeVerifier);
    }

    public static boolean matched(String codeChallenge, CodeChallengeMethod codeChallengeMethod, String codeVerifier) {
        if (Strings.isNullOrEmpty(codeChallenge) || codeChallengeMethod == null || Strings.isNullOrEmpty(codeVerifier)) {
            return false;
        }
        return CodeVerifier.generateCodeChallenge(codeChallengeMethod, codeVerifier).equals(codeChallenge);
    }

    public static String s256(String codeVerifier) {
        byte[] sha256 = DigestUtils.sha256(codeVerifier);
        return CodeVerifier.base64UrlEncode(sha256);
    }

    public static String base64UrlEncode(byte[] input) {
        Base64 base64 = new Base64(76, EMPTY_BYTE_ARRAY, true);
        return base64.encodeAsString(input);
    }

    public static String generateCodeVerifier() {
        String alphabetic = "abcdefghijklmnopqrstuvwxyz";
        String chars = alphabetic + alphabetic.toUpperCase() + "1234567890-._~";
        String code = RandomStringUtils.random(128, chars);
        Preconditions.checkState(CodeVerifier.isCodeVerifierValid(code));
        return code;
    }

    public static boolean isCodeVerifierValid(String codeVerifier) {
        if (codeVerifier == null) {
            return false;
        }
        int length = codeVerifier.length();
        return length <= 128 && length >= 43;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public CodeChallengeMethod getTransformationType() {
        return this.transformationType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CodeVerifier");
        sb.append("{codeVerifier='").append(this.codeVerifier).append('\'');
        sb.append(", codeChallenge='").append(this.codeChallenge).append('\'');
        sb.append(", transformationType=").append((Object)this.transformationType);
        sb.append('}');
        return sb.toString();
    }

    public static enum CodeChallengeMethod {
        PLAIN("plain", ""),
        S256("s256", "SHA-256");

        private String pkceString;
        private String messageDigestString;

        private CodeChallengeMethod(String pkceString, String messageDigestString) {
            this.pkceString = pkceString;
            this.messageDigestString = messageDigestString;
        }

        public String getMessageDigestString() {
            return this.messageDigestString;
        }

        public String getPkceString() {
            return this.pkceString;
        }

        public static CodeChallengeMethod fromString(String value) {
            for (CodeChallengeMethod type : CodeChallengeMethod.values()) {
                if (!type.getPkceString().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }
}

