/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client.uma.wrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.jboss.resteasy.client.ClientExecutor;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.uma.exception.UmaException;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.OxAuthCryptoProvider;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.uma.UmaScopeType;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.util.StringHelper;

public class UmaClient {
    public static Token requestPat(String tokenUrl, String clientKeyStoreFile, String clientKeyStorePassword, String clientId, String keyId) throws UmaException {
        TokenRequest tokenRequest = TokenRequest.builder().pat(new String[0]).grantType(GrantType.CLIENT_CREDENTIALS).build();
        return UmaClient.request(tokenUrl, clientKeyStoreFile, clientKeyStorePassword, clientId, keyId, tokenRequest);
    }

    @Deprecated
    public static Token requestPat(String authorizeUrl, String tokenUrl, String umaUserId, String umaUserSecret, String umaClientId, String umaClientSecret, String umaRedirectUri, String ... scopeArray) throws Exception {
        return UmaClient.request(authorizeUrl, tokenUrl, umaUserId, umaUserSecret, umaClientId, umaClientSecret, umaRedirectUri, UmaScopeType.PROTECTION, scopeArray);
    }

    public static Token requestPat(String tokenUrl, String umaClientId, String umaClientSecret, String ... scopeArray) throws Exception {
        return UmaClient.requestPat(tokenUrl, umaClientId, umaClientSecret, null, scopeArray);
    }

    public static Token requestPat(String tokenUrl, String umaClientId, String umaClientSecret, ClientExecutor clientExecutor, String ... scopeArray) throws Exception {
        return UmaClient.request(tokenUrl, umaClientId, umaClientSecret, UmaScopeType.PROTECTION, clientExecutor, scopeArray);
    }

    @Deprecated
    public static Token request(String authorizeUrl, String tokenUrl, String umaUserId, String umaUserSecret, String umaClientId, String umaClientSecret, String umaRedirectUri, UmaScopeType p_type, String ... scopeArray) throws Exception {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.CODE);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(p_type.getValue());
        if (scopeArray != null && scopeArray.length > 0) {
            scopes.addAll(Arrays.asList(scopeArray));
        }
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, umaClientId, scopes, umaRedirectUri, null);
        request.setState(state);
        request.setAuthUsername(umaUserId);
        request.setAuthPassword(umaUserSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(authorizeUrl);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec();
        String scope = response1.getScope();
        String authorizationCode = response1.getCode();
        if (Util.allNotBlank(authorizationCode)) {
            TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
            tokenRequest.setCode(authorizationCode);
            tokenRequest.setRedirectUri(umaRedirectUri);
            tokenRequest.setAuthUsername(umaClientId);
            tokenRequest.setAuthPassword(umaClientSecret);
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
            tokenRequest.setScope(scope);
            TokenClient tokenClient1 = new TokenClient(tokenUrl);
            tokenClient1.setRequest(tokenRequest);
            TokenResponse response2 = tokenClient1.exec();
            if (response2.getStatus() == 200) {
                String patToken = response2.getAccessToken();
                String patRefreshToken = response2.getRefreshToken();
                Integer expiresIn = response2.getExpiresIn();
                if (Util.allNotBlank(patToken, patRefreshToken)) {
                    return new Token(authorizationCode, patRefreshToken, patToken, scope, expiresIn);
                }
            }
        }
        return null;
    }

    public static Token request(String tokenUrl, String umaClientId, String umaClientSecret, UmaScopeType scopeType, ClientExecutor clientExecutor, String ... scopeArray) throws Exception {
        TokenResponse response;
        String scope = scopeType.getValue();
        if (scopeArray != null && scopeArray.length > 0) {
            for (String s : scopeArray) {
                scope = scope + " " + s;
            }
        }
        TokenClient tokenClient = new TokenClient(tokenUrl);
        if (clientExecutor != null) {
            tokenClient.setExecutor(clientExecutor);
        }
        if ((response = tokenClient.execClientCredentialsGrant(scope, umaClientId, umaClientSecret)).getStatus() == 200) {
            String patToken = response.getAccessToken();
            Integer expiresIn = response.getExpiresIn();
            if (Util.allNotBlank(patToken)) {
                return new Token(null, null, patToken, scopeType.getValue(), expiresIn);
            }
        }
        return null;
    }

    public static Token requestWithClientSecretJwt(String tokenUrl, String umaClientId, String umaClientSecret, AuthenticationMethod authenticationMethod, SignatureAlgorithm signatureAlgorithm, String audience, UmaScopeType scopeType, String ... scopeArray) throws Exception {
        String scope = scopeType.getValue();
        if (scopeArray != null && scopeArray.length > 0) {
            for (String s : scopeArray) {
                scope = scope + " " + s;
            }
        }
        TokenRequest request = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        request.setAuthUsername(umaClientId);
        request.setAuthPassword(umaClientSecret);
        request.setScope(scope);
        request.setAuthenticationMethod(authenticationMethod);
        request.setAlgorithm(signatureAlgorithm);
        request.setAudience(audience);
        return UmaClient.request(tokenUrl, request);
    }

    public static Token request(String tokenUrl, TokenRequest tokenRequest) throws Exception {
        if (tokenRequest.getGrantType() != GrantType.CLIENT_CREDENTIALS) {
            return null;
        }
        TokenClient tokenClient = new TokenClient(tokenUrl);
        tokenClient.setRequest(tokenRequest);
        TokenResponse response = tokenClient.exec();
        if (response.getStatus() == 200) {
            String patToken = response.getAccessToken();
            Integer expiresIn = response.getExpiresIn();
            if (Util.allNotBlank(patToken)) {
                return new Token(null, null, patToken, response.getScope(), expiresIn);
            }
        }
        return null;
    }

    private static Token request(String tokenUrl, String clientKeyStoreFile, String clientKeyStorePassword, String clientId, String keyId, TokenRequest tokenRequest) throws UmaException {
        OxAuthCryptoProvider cryptoProvider;
        try {
            cryptoProvider = new OxAuthCryptoProvider(clientKeyStoreFile, clientKeyStorePassword, null);
        }
        catch (Exception ex) {
            throw new UmaException("Failed to initialize crypto provider");
        }
        try {
            List<String> aliases;
            String tmpKeyId = keyId;
            if (StringHelper.isEmpty(tmpKeyId) && (aliases = cryptoProvider.getKeyAliases()).size() > 0) {
                tmpKeyId = aliases.get(0);
            }
            if (StringHelper.isEmpty(tmpKeyId)) {
                throw new UmaException("UMA keyId is empty");
            }
            SignatureAlgorithm algorithm = cryptoProvider.getSignatureAlgorithm(tmpKeyId);
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setCryptoProvider(cryptoProvider);
            tokenRequest.setAlgorithm(algorithm);
            tokenRequest.setKeyId(tmpKeyId);
            tokenRequest.setAudience(tokenUrl);
            Token umaPat = UmaClient.request(tokenUrl, tokenRequest);
            return umaPat;
        }
        catch (Exception ex) {
            throw new UmaException("Failed to obtain valid UMA PAT token", ex);
        }
    }
}

