/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;

public class RegisterClient
extends BaseClient<RegisterRequest, RegisterResponse> {
    private static final Logger LOG = Logger.getLogger(RegisterClient.class);

    public RegisterClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (this.getRequest() != null) {
            if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getHttpMethod())) {
                return ((RegisterRequest)this.getRequest()).getHttpMethod();
            }
            if (((RegisterRequest)this.getRequest()).getRegistrationAccessToken() != null) {
                return "GET";
            }
        }
        return "POST";
    }

    public RegisterResponse execRegister(ApplicationType applicationType, String clientName, List<String> redirectUri) {
        this.setRequest(new RegisterRequest(applicationType, clientName, redirectUri));
        return this.exec();
    }

    public RegisterResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public RegisterResponse exec(ClientExecutor clientExecutor) {
        this.clientRequest = new ClientRequest(this.getUrl(), clientExecutor);
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterResponse _exec() {
        try {
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.getHttpMethod().equals("POST") || this.getHttpMethod().equals("PUT")) {
                Map<String, String> customAttributes;
                this.clientRequest.header("Content-Type", ((RegisterRequest)this.getRequest()).getContentType());
                this.clientRequest.accept(((RegisterRequest)this.getRequest()).getMediaType());
                JSONObject requestBody = new JSONObject();
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getRegistrationAccessToken())) {
                    this.clientRequest.header("Authorization", "Bearer " + ((RegisterRequest)this.getRequest()).getRegistrationAccessToken());
                }
                if (((RegisterRequest)this.getRequest()).getRedirectUris() != null && !((RegisterRequest)this.getRequest()).getRedirectUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.REDIRECT_URIS.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getRedirectUris()));
                }
                if (((RegisterRequest)this.getRequest()).getClaimsRedirectUris() != null && !((RegisterRequest)this.getRequest()).getClaimsRedirectUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getClaimsRedirectUris()));
                }
                if (((RegisterRequest)this.getRequest()).getResponseTypes() != null && !((RegisterRequest)this.getRequest()).getResponseTypes().isEmpty()) {
                    requestBody.put(RegisterRequestParam.RESPONSE_TYPES.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getResponseTypes()));
                }
                if (((RegisterRequest)this.getRequest()).getGrantTypes() != null && !((RegisterRequest)this.getRequest()).getGrantTypes().isEmpty()) {
                    requestBody.put(RegisterRequestParam.GRANT_TYPES.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getGrantTypes()));
                }
                if (((RegisterRequest)this.getRequest()).getApplicationType() != null) {
                    requestBody.put(RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)((RegisterRequest)this.getRequest()).getApplicationType());
                }
                if (((RegisterRequest)this.getRequest()).getContacts() != null && !((RegisterRequest)this.getRequest()).getContacts().isEmpty()) {
                    requestBody.put(RegisterRequestParam.CONTACTS.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getContacts()));
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getClientName())) {
                    requestBody.put(RegisterRequestParam.CLIENT_NAME.toString(), ((RegisterRequest)this.getRequest()).getClientName());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getLogoUri())) {
                    requestBody.put(RegisterRequestParam.LOGO_URI.toString(), ((RegisterRequest)this.getRequest()).getLogoUri());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getClientUri())) {
                    requestBody.put(RegisterRequestParam.CLIENT_URI.toString(), ((RegisterRequest)this.getRequest()).getClientUri());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getPolicyUri())) {
                    requestBody.put(RegisterRequestParam.POLICY_URI.toString(), ((RegisterRequest)this.getRequest()).getPolicyUri());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getTosUri())) {
                    requestBody.put(RegisterRequestParam.TOS_URI.toString(), ((RegisterRequest)this.getRequest()).getTosUri());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getJwksUri())) {
                    requestBody.put(RegisterRequestParam.JWKS_URI.toString(), ((RegisterRequest)this.getRequest()).getJwksUri());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getJwks())) {
                    requestBody.put(RegisterRequestParam.JWKS.toString(), ((RegisterRequest)this.getRequest()).getJwks());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getSectorIdentifierUri())) {
                    requestBody.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), ((RegisterRequest)this.getRequest()).getSectorIdentifierUri());
                }
                if (((RegisterRequest)this.getRequest()).getSubjectType() != null) {
                    requestBody.put(RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)((RegisterRequest)this.getRequest()).getSubjectType());
                }
                if (((RegisterRequest)this.getRequest()).getIdTokenSignedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), ((RegisterRequest)this.getRequest()).getIdTokenSignedResponseAlg().getName());
                }
                if (((RegisterRequest)this.getRequest()).getIdTokenEncryptedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), ((RegisterRequest)this.getRequest()).getIdTokenEncryptedResponseAlg().getName());
                }
                if (((RegisterRequest)this.getRequest()).getIdTokenEncryptedResponseEnc() != null) {
                    requestBody.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), ((RegisterRequest)this.getRequest()).getIdTokenEncryptedResponseEnc().getName());
                }
                if (((RegisterRequest)this.getRequest()).getUserInfoSignedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), ((RegisterRequest)this.getRequest()).getUserInfoSignedResponseAlg().getName());
                }
                if (((RegisterRequest)this.getRequest()).getUserInfoEncryptedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), ((RegisterRequest)this.getRequest()).getUserInfoEncryptedResponseAlg().getName());
                }
                if (((RegisterRequest)this.getRequest()).getUserInfoEncryptedResponseEnc() != null) {
                    requestBody.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), ((RegisterRequest)this.getRequest()).getUserInfoEncryptedResponseEnc().getName());
                }
                if (((RegisterRequest)this.getRequest()).getRequestObjectSigningAlg() != null) {
                    requestBody.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), ((RegisterRequest)this.getRequest()).getRequestObjectSigningAlg().getName());
                }
                if (((RegisterRequest)this.getRequest()).getRequestObjectEncryptionAlg() != null) {
                    requestBody.put(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), ((RegisterRequest)this.getRequest()).getRequestObjectEncryptionAlg().getName());
                }
                if (((RegisterRequest)this.getRequest()).getRequestObjectEncryptionEnc() != null) {
                    requestBody.put(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), ((RegisterRequest)this.getRequest()).getRequestObjectEncryptionEnc().getName());
                }
                if (((RegisterRequest)this.getRequest()).getTokenEndpointAuthMethod() != null) {
                    requestBody.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)((RegisterRequest)this.getRequest()).getTokenEndpointAuthMethod());
                }
                if (((RegisterRequest)this.getRequest()).getTokenEndpointAuthSigningAlg() != null) {
                    requestBody.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), (Object)((RegisterRequest)this.getRequest()).getTokenEndpointAuthSigningAlg());
                }
                if (((RegisterRequest)this.getRequest()).getDefaultMaxAge() != null) {
                    requestBody.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), ((RegisterRequest)this.getRequest()).getDefaultMaxAge());
                }
                if (((RegisterRequest)this.getRequest()).getRequireAuthTime() != null) {
                    requestBody.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), ((RegisterRequest)this.getRequest()).getRequireAuthTime());
                }
                if (((RegisterRequest)this.getRequest()).getDefaultAcrValues() != null && !((RegisterRequest)this.getRequest()).getDefaultAcrValues().isEmpty()) {
                    requestBody.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), ((RegisterRequest)this.getRequest()).getDefaultAcrValues());
                }
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getInitiateLoginUri())) {
                    requestBody.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), ((RegisterRequest)this.getRequest()).getInitiateLoginUri());
                }
                if (((RegisterRequest)this.getRequest()).getPostLogoutRedirectUris() != null && !((RegisterRequest)this.getRequest()).getPostLogoutRedirectUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), ((RegisterRequest)this.getRequest()).getPostLogoutRedirectUris());
                }
                if (((RegisterRequest)this.getRequest()).getFrontChannelLogoutUris() != null && !((RegisterRequest)this.getRequest()).getFrontChannelLogoutUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.getName(), ((RegisterRequest)this.getRequest()).getFrontChannelLogoutUris());
                }
                if (((RegisterRequest)this.getRequest()).getClientSecretExpiresAt() != null) {
                    requestBody.put(RegisterRequestParam.CLIENT_SECRET_EXPIRES_AT_.toString(), ((RegisterRequest)this.getRequest()).getClientSecretExpiresAt().getTime());
                }
                if (((RegisterRequest)this.getRequest()).getFrontChannelLogoutSessionRequired() != null) {
                    requestBody.put(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.getName(), ((RegisterRequest)this.getRequest()).getFrontChannelLogoutSessionRequired());
                }
                if (((RegisterRequest)this.getRequest()).getRequestUris() != null && !((RegisterRequest)this.getRequest()).getRequestUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.REQUEST_URIS.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getRequestUris()));
                }
                if (((RegisterRequest)this.getRequest()).getAuthorizedOrigins() != null && !((RegisterRequest)this.getRequest()).getAuthorizedOrigins().isEmpty()) {
                    requestBody.put(RegisterRequestParam.AUTHORIZED_ORIGINS.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getAuthorizedOrigins()));
                }
                if (((RegisterRequest)this.getRequest()).getScopes() != null && !((RegisterRequest)this.getRequest()).getScopes().isEmpty()) {
                    requestBody.put(RegisterRequestParam.SCOPES.toString(), new JSONArray(((RegisterRequest)this.getRequest()).getScopes()));
                } else if (((RegisterRequest)this.getRequest()).getScope() != null && !((RegisterRequest)this.getRequest()).getScope().isEmpty()) {
                    String spaceSeparatedScope = org.xdi.oxauth.model.util.StringUtils.implode(((RegisterRequest)this.getRequest()).getScope(), " ");
                    requestBody.put(RegisterRequestParam.SCOPE.toString(), spaceSeparatedScope);
                }
                if (((RegisterRequest)this.getRequest()).getClaims() != null && !((RegisterRequest)this.getRequest()).getClaims().isEmpty()) {
                    String spaceSeparatedClaims = org.xdi.oxauth.model.util.StringUtils.implode(((RegisterRequest)this.getRequest()).getClaims(), " ");
                    requestBody.put(RegisterRequestParam.CLAIMS.toString(), spaceSeparatedClaims);
                }
                if ((customAttributes = ((RegisterRequest)this.getRequest()).getCustomAttributes()) != null && !customAttributes.isEmpty()) {
                    for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        if (!StringUtils.isNotBlank(name) || !StringUtils.isNotBlank(value)) continue;
                        requestBody.put(name, value);
                    }
                }
                this.clientRequest.body("application/json", (Object)requestBody.toString(4));
            } else {
                this.clientRequest.accept("application/json");
                if (StringUtils.isNotBlank(((RegisterRequest)this.getRequest()).getRegistrationAccessToken())) {
                    this.clientRequest.header("Authorization", "Bearer " + ((RegisterRequest)this.getRequest()).getRegistrationAccessToken());
                }
            }
            this.clientResponse = this.getHttpMethod().equals("POST") ? this.clientRequest.post(String.class) : (this.getHttpMethod().equals("PUT") ? this.clientRequest.put(String.class) : this.clientRequest.get(String.class));
            this.setResponse(new RegisterResponse(this.clientResponse));
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            this.closeConnection();
        }
        return (RegisterResponse)this.getResponse();
    }
}

