/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ClientInfoRequest;
import org.xdi.oxauth.client.ClientInfoResponse;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;

public class ClientInfoClient
extends BaseClient<ClientInfoRequest, ClientInfoResponse> {
    private static final Logger LOG = Logger.getLogger(ClientInfoClient.class);

    public ClientInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public ClientInfoResponse execClientInfo(String accessToken) {
        this.setRequest(new ClientInfoRequest(accessToken));
        return this.exec();
    }

    public ClientInfoResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public ClientInfoResponse exec(ClientExecutor p_executor) {
        this.clientRequest = new ClientRequest(this.getUrl(), p_executor);
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfoResponse _exec() {
        block22: {
            this.clientRequest.header("Content-Type", "application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                if (StringUtils.isNotBlank(((ClientInfoRequest)this.getRequest()).getAccessToken())) {
                    this.clientRequest.header("Authorization", "Bearer " + ((ClientInfoRequest)this.getRequest()).getAccessToken());
                }
            } else if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                if (StringUtils.isNotBlank(((ClientInfoRequest)this.getRequest()).getAccessToken())) {
                    this.clientRequest.formParameter("access_token", ((ClientInfoRequest)this.getRequest()).getAccessToken());
                }
            } else if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER && StringUtils.isNotBlank(((ClientInfoRequest)this.getRequest()).getAccessToken())) {
                this.clientRequest.queryParameter("access_token", ((ClientInfoRequest)this.getRequest()).getAccessToken());
            }
            try {
                this.clientResponse = ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.setResponse(new ClientInfoResponse(status));
                String entity = this.clientResponse.getEntity(String.class);
                ((ClientInfoResponse)this.getResponse()).setEntity(entity);
                ((ClientInfoResponse)this.getResponse()).setHeaders(this.clientResponse.getMetadata());
                if (!StringUtils.isNotBlank(entity)) break block22;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        ((ClientInfoResponse)this.getResponse()).setErrorType(UserInfoErrorResponseType.fromString(jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        ((ClientInfoResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        ((ClientInfoResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ArrayList<String> values = new ArrayList<String>();
                        JSONArray jsonArray = jsonObj.optJSONArray(key);
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value = jsonArray.optString(i);
                                if (value == null) continue;
                                values.add(value);
                            }
                        } else {
                            String value = jsonObj.optString(key);
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        ((ClientInfoResponse)this.getResponse()).getClaims().put(key, values);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
            finally {
                this.closeConnection();
            }
        }
        return (ClientInfoResponse)this.getResponse();
    }
}

