/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.model.metric;

import java.util.HashMap;
import java.util.Map;
import org.gluu.site.ldap.persistence.annotation.LdapEnum;
import org.xdi.model.metric.MetricData;
import org.xdi.model.metric.counter.CounterMetricData;
import org.xdi.model.metric.counter.CounterMetricEntry;
import org.xdi.model.metric.ldap.MetricEntry;
import org.xdi.model.metric.timer.TimerMetricData;
import org.xdi.model.metric.timer.TimerMetricEntry;

public enum MetricType implements LdapEnum
{
    OXAUTH_USER_AUTHENTICATION_SUCCESS("user_authentication_success", "Count successfull oxAuth user authentications", CounterMetricData.class, CounterMetricEntry.class),
    OXAUTH_USER_AUTHENTICATION_FAILURES("user_authentication_failure", "Count failed oxAuth user authentications", CounterMetricData.class, CounterMetricEntry.class),
    OXAUTH_USER_AUTHENTICATION_RATE("user_authentication_rate", "User authentication rate", TimerMetricData.class, TimerMetricEntry.class),
    DYNAMIC_CLIENT_REGISTRATION_RATE("dynamic_client_registration_rate", "Dynamic client registration rate", TimerMetricData.class, TimerMetricEntry.class);

    private String value;
    private String displayName;
    private Class<? extends MetricData> eventDataType;
    private Class<? extends MetricEntry> metricEntryType;
    private static Map<String, MetricType> MAP_BY_VALUES;

    private MetricType(String value, String displayName, Class<? extends MetricData> eventDataType, Class<? extends MetricEntry> metricEntryType) {
        this.value = value;
        this.displayName = displayName;
        this.eventDataType = eventDataType;
        this.metricEntryType = metricEntryType;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMetricName() {
        return this.value;
    }

    public static MetricType getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    @Override
    public Enum<? extends LdapEnum> resolveByValue(String value) {
        return MetricType.getByValue(value);
    }

    public Class<? extends MetricData> getEventDataType() {
        return this.eventDataType;
    }

    public Class<? extends MetricEntry> getMetricEntryType() {
        return this.metricEntryType;
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, MetricType>();
        for (MetricType enumType : MetricType.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

