/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxeleven.client;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.gluu.oxeleven.client.BaseRequest;

public class GenerateKeyRequest
extends BaseRequest {
    private String signatureAlgorithm;
    private Long expirationTime;

    public GenerateKeyRequest() {
        this.setContentType("application/x-www-form-urlencoded");
        this.setMediaType("application/x-www-form-urlencoded");
        this.setHttpMethod("POST");
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            if (!Strings.isNullOrEmpty(this.signatureAlgorithm)) {
                queryStringBuilder.append("signatureAlgorithm").append("=").append(URLEncoder.encode(this.signatureAlgorithm, "UTF-8"));
            }
            if (this.expirationTime != null) {
                queryStringBuilder.append("&").append("expirationTime").append("=").append(this.expirationTime);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

