/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.config.InputStreamWrapper;
import org.apache.log4j.config.Log4j1ConfigurationParser;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.util.BasicCommandLineArguments;

public final class Log4j1ConfigurationConverter {
    private static final String FILE_EXT_XML = ".xml";
    private final CommandLineArguments cla;

    public static void main(String[] args) {
        new Log4j1ConfigurationConverter(BasicCommandLineArguments.parseCommandLine(args, Log4j1ConfigurationConverter.class, new CommandLineArguments())).run();
    }

    public static Log4j1ConfigurationConverter run(CommandLineArguments cla) {
        Log4j1ConfigurationConverter log4j1ConfigurationConverter = new Log4j1ConfigurationConverter(cla);
        log4j1ConfigurationConverter.run();
        return log4j1ConfigurationConverter;
    }

    private Log4j1ConfigurationConverter(CommandLineArguments cla) {
        this.cla = cla;
    }

    protected void convert(InputStream input, OutputStream output) throws IOException {
        ConfigurationBuilder<BuiltConfiguration> builder = new Log4j1ConfigurationParser().buildConfigurationBuilder(input);
        builder.writeXmlConfiguration(output);
    }

    InputStream getInputStream() throws IOException {
        Path pathIn = this.cla.getPathIn();
        return pathIn == null ? System.in : new InputStreamWrapper(Files.newInputStream(pathIn, new OpenOption[0]), pathIn.toString());
    }

    OutputStream getOutputStream() throws IOException {
        Path pathOut = this.cla.getPathOut();
        return pathOut == null ? System.out : Files.newOutputStream(pathOut, new OpenOption[0]);
    }

    private void run() {
        block32: {
            block31: {
                if (this.cla.getRecurseIntoPath() == null) break block31;
                final AtomicInteger countOKs = new AtomicInteger();
                final AtomicInteger countFails = new AtomicInteger();
                try {
                    Files.walkFileTree(this.cla.getRecurseIntoPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (Log4j1ConfigurationConverter.this.cla.getPathIn() == null || file.getFileName().equals(Log4j1ConfigurationConverter.this.cla.getPathIn())) {
                                Log4j1ConfigurationConverter.this.verbose("Reading %s", new Object[]{file});
                                String newFile = file.getFileName().toString();
                                int lastIndex = newFile.lastIndexOf(".");
                                newFile = lastIndex < 0 ? newFile + Log4j1ConfigurationConverter.FILE_EXT_XML : newFile.substring(0, lastIndex) + Log4j1ConfigurationConverter.FILE_EXT_XML;
                                Path resolved = file.resolveSibling(newFile);
                                try (InputStreamWrapper input = new InputStreamWrapper(Files.newInputStream(file, new OpenOption[0]), file.toString());
                                     OutputStream output = Files.newOutputStream(resolved, new OpenOption[0]);){
                                    try {
                                        Log4j1ConfigurationConverter.this.convert(input, output);
                                        countOKs.incrementAndGet();
                                    }
                                    catch (IOException | ConfigurationException e) {
                                        countFails.incrementAndGet();
                                        if (Log4j1ConfigurationConverter.this.cla.isFailFast()) {
                                            throw e;
                                        }
                                        e.printStackTrace();
                                    }
                                    Log4j1ConfigurationConverter.this.verbose("Wrote %s", new Object[]{resolved});
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    try {
                        throw new ConfigurationException(e);
                    }
                    catch (Throwable throwable) {
                        this.verbose("OK = %,d, Failures = %,d, Total = %,d", countOKs.get(), countFails.get(), countOKs.get() + countFails.get());
                        throw throwable;
                    }
                }
                this.verbose("OK = %,d, Failures = %,d, Total = %,d", countOKs.get(), countFails.get(), countOKs.get() + countFails.get());
                break block32;
            }
            this.verbose("Reading %s", this.cla.getPathIn());
            try (InputStream input = this.getInputStream();
                 OutputStream output = this.getOutputStream();){
                this.convert(input, output);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            this.verbose("Wrote %s", this.cla.getPathOut());
        }
    }

    private void verbose(String template, Object ... args) {
        if (this.cla.isVerbose()) {
            System.err.println(String.format(template, args));
        }
    }

    public static class CommandLineArguments
    extends BasicCommandLineArguments {
        @Parameter(names={"--failfast", "-f"}, description="Fails on the first failure in recurse mode.")
        private boolean failFast;
        @Parameter(names={"--in", "-i"}, description="Specifies the input file.")
        private Path pathIn;
        @Parameter(names={"--out", "-o"}, description="Specifies the output file.")
        private Path pathOut;
        @Parameter(names={"--recurse", "-r"}, description="Recurses into this folder looking for the input file")
        private Path recurseIntoPath;
        @Parameter(names={"--verbose", "-v"}, description="Be verbose.")
        private boolean verbose;

        public Path getPathIn() {
            return this.pathIn;
        }

        public Path getPathOut() {
            return this.pathOut;
        }

        public Path getRecurseIntoPath() {
            return this.recurseIntoPath;
        }

        public boolean isFailFast() {
            return this.failFast;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public void setPathIn(Path pathIn) {
            this.pathIn = pathIn;
        }

        public void setPathOut(Path pathOut) {
            this.pathOut = pathOut;
        }

        public void setRecurseIntoPath(Path recurseIntoPath) {
            this.recurseIntoPath = recurseIntoPath;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public String toString() {
            return "CommandLineArguments [recurseIntoPath=" + this.recurseIntoPath + ", verbose=" + this.verbose + ", pathIn=" + this.pathIn + ", pathOut=" + this.pathOut + "]";
        }
    }
}

