/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client.model.authorize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClaimValue {
    private ClaimValueType claimValueType;
    private List<String> values;
    private String value;

    private ClaimValue() {
    }

    public static ClaimValue createNull() {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = ClaimValueType.NULL;
        return claimValue;
    }

    public static ClaimValue createEssential(boolean essentialValue) {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = essentialValue ? ClaimValueType.ESSENTIAL_TRUE : ClaimValueType.ESSENTIAL_FALSE;
        return claimValue;
    }

    public static ClaimValue createValueList(String[] values) {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = ClaimValueType.VALUE_LIST;
        claimValue.values = new ArrayList<String>();
        Collections.addAll(claimValue.values, values);
        return claimValue;
    }

    public static ClaimValue createSingleValue(String value) {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = ClaimValueType.SINGLE_VALUE;
        claimValue.value = value;
        return claimValue;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject obj = null;
        switch (this.claimValueType) {
            case NULL: {
                break;
            }
            case ESSENTIAL_TRUE: {
                obj = new JSONObject();
                obj.put("essential", true);
                break;
            }
            case ESSENTIAL_FALSE: {
                obj = new JSONObject();
                obj.put("essential", false);
                break;
            }
            case VALUE_LIST: {
                JSONArray arr = new JSONArray();
                for (String value : this.values) {
                    arr.put((Object)value);
                }
                obj = new JSONObject();
                obj.put("values", (Object)arr);
                break;
            }
            case SINGLE_VALUE: {
                obj = new JSONObject();
                obj.put("value", (Object)this.value);
            }
        }
        return obj;
    }

    static enum ClaimValueType {
        NULL,
        ESSENTIAL_TRUE,
        ESSENTIAL_FALSE,
        VALUE_LIST,
        SINGLE_VALUE;

    }
}

