/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jws.JwsValidator;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;

public class UserInfoClient
extends BaseClient<UserInfoRequest, UserInfoResponse> {
    private String sharedKey;
    private RSAPrivateKey rsaPrivateKey;
    private String jwksUri;

    public UserInfoClient(String url) {
        super(url);
    }

    @Override
    public UserInfoRequest getRequest() {
        if (this.request instanceof UserInfoRequest) {
            return (UserInfoRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(UserInfoRequest request) {
        this.request = request;
    }

    @Override
    public UserInfoResponse getResponse() {
        if (this.response instanceof UserInfoResponse) {
            return (UserInfoResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(UserInfoResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
            return "GET";
        }
        return "POST";
    }

    public UserInfoResponse execUserInfo(String accessToken) {
        this.setRequest(new UserInfoRequest(accessToken));
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfoResponse exec() {
        block29: {
            this.initClientRequest();
            this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.getRequest().getAuthorizationMethod() == null || this.getRequest().getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
                if (StringUtils.isNotBlank((String)this.getRequest().getAccessToken())) {
                    this.clientRequest.header("Authorization", (Object)("Bearer " + this.getRequest().getAccessToken()));
                }
            } else if (this.getRequest().getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                if (StringUtils.isNotBlank((String)this.getRequest().getAccessToken())) {
                    this.clientRequest.formParameter("access_token", (Object)this.getRequest().getAccessToken());
                }
            } else if (this.getRequest().getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER && StringUtils.isNotBlank((String)this.getRequest().getAccessToken())) {
                this.clientRequest.queryParameter("access_token", (Object)this.getRequest().getAccessToken());
            }
            try {
                if (this.getRequest().getAuthorizationMethod() == null || this.getRequest().getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.getRequest().getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
                    this.clientResponse = this.clientRequest.get(String.class);
                } else if (this.getRequest().getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                    this.clientResponse = this.clientRequest.post(String.class);
                }
                int status = this.clientResponse.getStatus();
                this.setResponse(new UserInfoResponse(status));
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.getResponse().setEntity(entity);
                this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                if (!StringUtils.isNotBlank((String)entity)) break block29;
                List contentType = (List)this.clientResponse.getHeaders().get((Object)"Content-Type");
                if (contentType != null && contentType.contains("application/jwt")) {
                    String[] jwtParts = entity.split("\\.");
                    if (jwtParts.length == 5) {
                        byte[] sharedSymmetricKey = this.sharedKey != null ? this.sharedKey.getBytes("UTF-8") : null;
                        Jwe jwe = Jwe.parse((String)entity, (RSAPrivateKey)this.rsaPrivateKey, (byte[])sharedSymmetricKey);
                        this.getResponse().setClaims(jwe.getClaims().toMap());
                    } else {
                        Jwt jwt = Jwt.parse((String)entity);
                        JwsValidator jwtValidator = new JwsValidator(jwt, this.sharedKey, this.jwksUri);
                        if (jwtValidator.validateSignature()) {
                            this.getResponse().setClaims(jwt.getClaims().toMap());
                        }
                    }
                    break block29;
                }
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        this.getResponse().setErrorType(UserInfoErrorResponseType.fromString((String)jsonObj.getString("error")));
                        jsonObj.remove("error");
                    }
                    if (jsonObj.has("error_description")) {
                        this.getResponse().setErrorDescription(jsonObj.getString("error_description"));
                        jsonObj.remove("error_description");
                    }
                    if (jsonObj.has("error_uri")) {
                        this.getResponse().setErrorUri(jsonObj.getString("error_uri"));
                        jsonObj.remove("error_uri");
                    }
                    Iterator iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ArrayList<String> values = new ArrayList<String>();
                        JSONArray jsonArray = jsonObj.optJSONArray(key);
                        if (jsonArray != null) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value = jsonArray.optString(i);
                                if (value == null) continue;
                                values.add(value);
                            }
                        } else {
                            String value = jsonObj.optString(key);
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        this.getResponse().getClaims().put(key, values);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.getResponse();
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }
}

