/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;

public class RegisterClient
extends BaseClient<RegisterRequest, RegisterResponse> {
    private static final Logger LOG = Logger.getLogger(RegisterClient.class);

    public RegisterClient(String url) {
        super(url);
    }

    @Override
    public RegisterRequest getRequest() {
        if (this.request instanceof RegisterRequest) {
            return (RegisterRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(RegisterRequest request) {
        this.request = request;
    }

    @Override
    public RegisterResponse getResponse() {
        if (this.response instanceof RegisterResponse) {
            return (RegisterResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(RegisterResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        if (this.getRequest() != null) {
            if (StringUtils.isNotBlank((String)this.getRequest().getHttpMethod())) {
                return this.getRequest().getHttpMethod();
            }
            if (this.getRequest().getRegistrationAccessToken() != null) {
                return "GET";
            }
        }
        return "POST";
    }

    public RegisterResponse execRegister(ApplicationType applicationType, String clientName, List<String> redirectUri) {
        this.setRequest(new RegisterRequest(applicationType, clientName, redirectUri));
        return this.exec();
    }

    public RegisterResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public RegisterResponse exec(ClientExecutor clientExecutor) {
        this.clientRequest = new ClientRequest(this.getUrl(), clientExecutor);
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterResponse _exec() {
        try {
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (this.getHttpMethod().equals("POST") || this.getHttpMethod().equals("PUT")) {
                Map<String, String> customAttributes;
                this.clientRequest.header("Content-Type", (Object)this.getRequest().getContentType());
                this.clientRequest.accept(this.getRequest().getMediaType());
                JSONObject requestBody = new JSONObject();
                if (StringUtils.isNotBlank((String)this.getRequest().getRegistrationAccessToken())) {
                    this.clientRequest.header("Authorization", (Object)("Bearer " + this.getRequest().getRegistrationAccessToken()));
                }
                if (this.getRequest().getRedirectUris() != null && !this.getRequest().getRedirectUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.REDIRECT_URIS.toString(), (Object)new JSONArray(this.getRequest().getRedirectUris()));
                }
                if (this.getRequest().getResponseTypes() != null && !this.getRequest().getResponseTypes().isEmpty()) {
                    requestBody.put(RegisterRequestParam.RESPONSE_TYPES.toString(), (Object)new JSONArray(this.getRequest().getResponseTypes()));
                }
                if (this.getRequest().getGrantTypes() != null && !this.getRequest().getGrantTypes().isEmpty()) {
                    requestBody.put(RegisterRequestParam.GRANT_TYPES.toString(), (Object)new JSONArray(this.getRequest().getGrantTypes()));
                }
                if (this.getRequest().getApplicationType() != null) {
                    requestBody.put(RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)this.getRequest().getApplicationType());
                }
                if (this.getRequest().getContacts() != null && !this.getRequest().getContacts().isEmpty()) {
                    requestBody.put(RegisterRequestParam.CONTACTS.toString(), (Object)new JSONArray(this.getRequest().getContacts()));
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getClientName())) {
                    requestBody.put(RegisterRequestParam.CLIENT_NAME.toString(), (Object)this.getRequest().getClientName());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getLogoUri())) {
                    requestBody.put(RegisterRequestParam.LOGO_URI.toString(), (Object)this.getRequest().getLogoUri());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getClientUri())) {
                    requestBody.put(RegisterRequestParam.CLIENT_URI.toString(), (Object)this.getRequest().getClientUri());
                }
                if (this.getRequest().getTokenEndpointAuthMethod() != null) {
                    requestBody.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)this.getRequest().getTokenEndpointAuthMethod());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getPolicyUri())) {
                    requestBody.put(RegisterRequestParam.POLICY_URI.toString(), (Object)this.getRequest().getPolicyUri());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getTosUri())) {
                    requestBody.put(RegisterRequestParam.TOS_URI.toString(), (Object)this.getRequest().getTosUri());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getJwksUri())) {
                    requestBody.put(RegisterRequestParam.JWKS_URI.toString(), (Object)this.getRequest().getJwksUri());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getSectorIdentifierUri())) {
                    requestBody.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)this.getRequest().getSectorIdentifierUri());
                }
                if (this.getRequest().getSubjectType() != null) {
                    requestBody.put(RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)this.getRequest().getSubjectType());
                }
                if (this.getRequest().getRequestObjectSigningAlg() != null) {
                    requestBody.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)this.getRequest().getRequestObjectSigningAlg().getName());
                }
                if (this.getRequest().getUserInfoSignedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)this.getRequest().getUserInfoSignedResponseAlg().getName());
                }
                if (this.getRequest().getUserInfoEncryptedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.getRequest().getUserInfoEncryptedResponseAlg().getName());
                }
                if (this.getRequest().getUserInfoEncryptedResponseEnc() != null) {
                    requestBody.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.getRequest().getUserInfoEncryptedResponseEnc().getName());
                }
                if (this.getRequest().getIdTokenSignedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)this.getRequest().getIdTokenSignedResponseAlg().getName());
                }
                if (this.getRequest().getIdTokenEncryptedResponseAlg() != null) {
                    requestBody.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.getRequest().getIdTokenEncryptedResponseAlg().getName());
                }
                if (this.getRequest().getIdTokenEncryptedResponseEnc() != null) {
                    requestBody.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.getRequest().getIdTokenEncryptedResponseEnc().getName());
                }
                if (this.getRequest().getDefaultMaxAge() != null) {
                    requestBody.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)this.getRequest().getDefaultMaxAge());
                }
                if (this.getRequest().getRequireAuthTime() != null) {
                    requestBody.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)this.getRequest().getRequireAuthTime());
                }
                if (this.getRequest().getDefaultAcrValues() != null && !this.getRequest().getDefaultAcrValues().isEmpty()) {
                    requestBody.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), this.getRequest().getDefaultAcrValues());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getInitiateLoginUri())) {
                    requestBody.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)this.getRequest().getInitiateLoginUri());
                }
                if (this.getRequest().getPostLogoutRedirectUris() != null && !this.getRequest().getPostLogoutRedirectUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), this.getRequest().getPostLogoutRedirectUris());
                }
                if (this.getRequest().getRequestUris() != null && !this.getRequest().getRequestUris().isEmpty()) {
                    requestBody.put(RegisterRequestParam.REQUEST_URIS.toString(), (Object)new JSONArray(this.getRequest().getRequestUris()));
                }
                if (this.getRequest().getScopes() != null && !this.getRequest().getScopes().isEmpty()) {
                    requestBody.put(RegisterRequestParam.SCOPES.toString(), (Object)new JSONArray(this.getRequest().getScopes()));
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getFederationUrl())) {
                    requestBody.put(RegisterRequestParam.FEDERATION_METADATA_URL.toString(), (Object)this.getRequest().getFederationUrl());
                }
                if (StringUtils.isNotBlank((String)this.getRequest().getFederationId())) {
                    requestBody.put(RegisterRequestParam.FEDERATION_METADATA_ID.toString(), (Object)this.getRequest().getFederationId());
                }
                if ((customAttributes = this.getRequest().getCustomAttributes()) != null && !customAttributes.isEmpty()) {
                    for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank((String)value)) continue;
                        requestBody.put(name, (Object)value);
                    }
                }
                this.clientRequest.body("application/json", (Object)requestBody.toString(4));
            } else {
                this.clientRequest.accept("application/json");
                if (StringUtils.isNotBlank((String)this.getRequest().getRegistrationAccessToken())) {
                    this.clientRequest.header("Authorization", (Object)("Bearer " + this.getRequest().getRegistrationAccessToken()));
                }
            }
            this.clientResponse = this.getHttpMethod().equals("POST") ? this.clientRequest.post(String.class) : (this.getHttpMethod().equals("PUT") ? this.clientRequest.put(String.class) : this.clientRequest.get(String.class));
            this.setResponse(new RegisterResponse((ClientResponse<String>)this.clientResponse));
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return this.getResponse();
    }
}

