/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.List;
import org.xdi.oxauth.client.BaseResponse;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jwk.JSONWebKey;

public class JwkResponse
extends BaseResponse {
    private List<JSONWebKey> keys;

    public JwkResponse(int status) {
        super(status);
    }

    public List<JSONWebKey> getKeys() {
        return this.keys;
    }

    public void setKeys(List<JSONWebKey> keys) {
        this.keys = keys;
    }

    public JSONWebKey getKeyValue(String keyId) {
        for (JSONWebKey JSONWebKey2 : this.keys) {
            if (!JSONWebKey2.getKeyId().equals(keyId)) continue;
            return JSONWebKey2;
        }
        return null;
    }

    public PublicKey getPublicKey(String keyId) {
        RSAPublicKey publicKey = null;
        JSONWebKey JSONWebKey2 = this.getKeyValue(keyId);
        if (JSONWebKey2 != null && JSONWebKey2.getPublicKey() != null) {
            switch (JSONWebKey2.getKeyType()) {
                case RSA: {
                    publicKey = new RSAPublicKey(JSONWebKey2.getPublicKey().getModulus(), JSONWebKey2.getPublicKey().getExponent());
                    break;
                }
                case EC: {
                    publicKey = new ECDSAPublicKey(SignatureAlgorithm.fromName((String)JSONWebKey2.getCurve()), JSONWebKey2.getPublicKey().getX(), JSONWebKey2.getPublicKey().getY());
                    break;
                }
            }
        }
        return publicKey;
    }
}

